/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.ThriftUtils;
import io.warp10.WarpDist;
import io.warp10.crypto.CryptoUtils;
import io.warp10.crypto.OrderPreservingBase64;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.thrift.data.SecureScript;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPOutputStream;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;

public class SECURE
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static byte[] aesKey = null;

    public SECURE(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        if (null == stack.getAttribute("secure.key")) {
            throw new WarpScriptException("You need to set the secure key first.");
        }
        if (!(o instanceof String)) {
            throw new WarpScriptException(this.getName() + " operates on a string.");
        }
        stack.push(SECURE.secure(stack.getAttribute("secure.key").toString(), o.toString()));
        return stack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String secure(String key, String script) throws WarpScriptException {
        SecureScript sscript = new SecureScript();
        sscript.setTimestamp(System.currentTimeMillis());
        sscript.setKey(key);
        byte[] scriptBytes = script.getBytes(StandardCharsets.UTF_8);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean compress = false;
        try {
            GZIPOutputStream gzos = new GZIPOutputStream(baos);
            gzos.write(scriptBytes);
            gzos.close();
            byte[] gzipped = baos.toByteArray();
            if (gzipped.length < scriptBytes.length) {
                compress = true;
                scriptBytes = gzipped;
            }
        }
        catch (IOException gzos) {
            // empty catch block
        }
        sscript.setCompressed(compress);
        sscript.setScript(scriptBytes);
        TSerializer serializer = ThriftUtils.getTSerializer();
        try {
            byte[] serialized = serializer.serialize((TBase)sscript);
            Class<SECURE> clazz = SECURE.class;
            synchronized (SECURE.class) {
                if (null == aesKey) {
                    try {
                        aesKey = WarpDist.getKeyStore().getKey("warp.aes.securescripts");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                // ** MonitorExit[var8_10] (shouldn't be in output)
                if (null == aesKey) {
                    throw new WarpScriptException("Missing secure script encryption key.");
                }
                byte[] wrapped = CryptoUtils.wrap(aesKey, serialized);
                String encoded = new String(OrderPreservingBase64.encode(wrapped), StandardCharsets.US_ASCII);
                return encoded;
            }
        }
        catch (TException te) {
            throw new WarpScriptException("Unable to secure script.", te);
        }
    }
}

