/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class REOPTALT
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public REOPTALT(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof List)) {
            throw new WarpScriptException(this.getName() + " expects a list of strings on top of the stack.");
        }
        ArrayList<String> alternatives = new ArrayList<String>();
        for (Object o : (List)top) {
            alternatives.add(String.valueOf(o));
        }
        stack.push(REOPTALT.buildOptAlt(alternatives));
        return stack;
    }

    private static final String buildOptAlt(List<String> alternatives) {
        if (alternatives.isEmpty()) {
            return "";
        }
        if (alternatives.size() == 1) {
            return REOPTALT.escape(alternatives.get(0));
        }
        HashSet<String> uniques = new HashSet<String>(alternatives);
        boolean hasEmpty = uniques.remove("");
        if (uniques.isEmpty()) {
            return "";
        }
        alternatives = new ArrayList<String>(uniques);
        Collections.sort(alternatives);
        int len = 1;
        int prevcard = Integer.MAX_VALUE;
        int cardinality = 0;
        int minlen = alternatives.get(0).length();
        while (cardinality <= prevcard && len <= minlen) {
            cardinality = 1;
            block1: for (int idx = 1; idx < alternatives.size() && cardinality <= prevcard; ++idx) {
                int mlen;
                String previous = alternatives.get(idx - 1);
                String current = alternatives.get(idx);
                if (1 == len && (mlen = current.length()) < minlen) {
                    minlen = mlen;
                }
                for (int i = 0; i < len; ++i) {
                    if (previous.charAt(i) == current.charAt(i)) continue;
                    ++cardinality;
                    continue block1;
                }
            }
            if (cardinality <= prevcard) {
                prevcard = cardinality;
                ++len;
                continue;
            }
            --len;
        }
        if (len > minlen) {
            len = minlen;
        }
        StringBuilder regexp = new StringBuilder("(");
        if (hasEmpty) {
            regexp.append("|");
        }
        String prefix = alternatives.get(0).substring(0, len);
        int nprefixes = 0;
        HashSet<String> suffixes = new HashSet<String>();
        for (int idx = 0; idx < alternatives.size(); ++idx) {
            String alternative = alternatives.get(idx);
            if (alternative.startsWith(prefix)) {
                suffixes.add(alternative.substring(len));
                continue;
            }
            if (nprefixes > 0) {
                regexp.append("|");
            }
            regexp.append(REOPTALT.escape(prefix));
            ArrayList<String> subalts = new ArrayList<String>(suffixes);
            int length = -1;
            if (subalts.size() > 1) {
                for (String suffix : subalts) {
                    if (-1 == length) {
                        length = suffix.length();
                    }
                    if (suffix.length() == length) continue;
                    length = -1;
                    break;
                }
            }
            String end = "";
            int endlen = 0;
            if (-1 != length) {
                endlen = length - 1;
                boolean done = false;
                while (!done && endlen > 0) {
                    end = ((String)subalts.get(0)).substring(length - endlen);
                    done = true;
                    for (String suffix : subalts) {
                        if (suffix.endsWith(end)) continue;
                        done = false;
                        break;
                    }
                    if (done) continue;
                    --endlen;
                }
                if (endlen > 0) {
                    for (int i = 0; i < subalts.size(); ++i) {
                        String subalt = (String)subalts.get(i);
                        subalts.set(i, subalt.substring(0, subalt.length() - endlen));
                    }
                }
            }
            regexp.append(REOPTALT.buildOptAlt(subalts));
            if (endlen > 0) {
                regexp.append(REOPTALT.escape(end));
            }
            suffixes.clear();
            suffixes.add(alternative.substring(len));
            prefix = alternative.substring(0, len);
            ++nprefixes;
        }
        if (nprefixes > 0) {
            regexp.append("|");
        }
        regexp.append(REOPTALT.escape(prefix));
        ArrayList<String> subalts = new ArrayList<String>(suffixes);
        int length = -1;
        if (subalts.size() > 1) {
            for (String suffix : subalts) {
                if (-1 == length) {
                    length = suffix.length();
                }
                if (suffix.length() == length) continue;
                length = -1;
                break;
            }
        }
        String end = "";
        int endlen = 0;
        if (-1 != length) {
            endlen = length - 1;
            boolean done = false;
            while (!done && endlen > 0) {
                end = ((String)subalts.get(0)).substring(length - endlen);
                done = true;
                for (String suffix : subalts) {
                    if (suffix.endsWith(end)) continue;
                    done = false;
                    break;
                }
                if (done) continue;
                --endlen;
            }
            if (endlen > 0) {
                for (int i = 0; i < subalts.size(); ++i) {
                    String subalt = (String)subalts.get(i);
                    subalts.set(i, subalt.substring(0, subalt.length() - endlen));
                }
            }
        }
        regexp.append(REOPTALT.buildOptAlt(subalts));
        if (endlen > 0) {
            regexp.append(REOPTALT.escape(end));
        }
        regexp.append(")");
        boolean valid = true;
        int count = (regexp.length() - 2 - 1) / 2;
        for (int i = 1; i < regexp.length() - 1; ++i) {
            if ('|' != regexp.charAt(i)) continue;
            --count;
            if (i % 2 == 0) continue;
            valid = false;
            break;
        }
        if (valid && 0 == count && -1 == regexp.indexOf("-")) {
            regexp.deleteCharAt(0);
            regexp.deleteCharAt(regexp.length() - 1);
            while (regexp.indexOf("|") >= 0) {
                regexp.deleteCharAt(regexp.indexOf("|"));
            }
            regexp.insert(0, "[");
            regexp.append("]");
        }
        return regexp.toString();
    }

    private static final String escape(String str) {
        str = str.replaceAll("\\\\", "\\\\");
        str = str.replaceAll("\\[", "\\\\[");
        str = str.replaceAll("\\]", "\\\\]");
        str = str.replaceAll("\\{", "\\\\{");
        str = str.replaceAll("\\}", "\\\\}");
        str = str.replaceAll("\\(", "\\\\(");
        str = str.replaceAll("\\)", "\\\\)");
        str = str.replaceAll("\\|", "\\\\|");
        str = str.replaceAll("\\.", "\\\\.");
        str = str.replaceAll("\\?", "\\\\?");
        str = str.replaceAll("\\+", "\\\\+");
        str = str.replaceAll("\\*", "\\\\*");
        return str;
    }
}

