/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSDecoder;
import io.warp10.continuum.gts.GTSEncoder;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class PIVOT
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final boolean synchronous;

    public PIVOT(String name, boolean sync) {
        super(name);
        this.synchronous = sync;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof List) || 0 == ((List)top).size()) {
            throw new WarpScriptException(this.getName() + " expects a non empty list of labeling Geo Time Series.");
        }
        List paramLabeling = (List)top;
        ArrayList labeling = new ArrayList(paramLabeling.size());
        HashSet classes = new HashSet();
        for (Object o : paramLabeling) {
            if (o instanceof GTSEncoder) {
                GTSEncoder encoder = (GTSEncoder)o;
                GTSDecoder decoder = encoder.getDecoder(true);
                try {
                    o = decoder.decode(null, true);
                }
                catch (Throwable t) {
                    throw new WarpScriptException(this.getName() + " encountered an error while decoding encoder.", t);
                }
            }
            if (!(o instanceof GeoTimeSerie)) {
                throw new WarpScriptException(this.getName() + " expects a list of labeling Geo Time Series.");
            }
            labeling.add(o);
            if (0 == GTSHelper.nvalues((GeoTimeSerie)o)) {
                throw new WarpScriptException(this.getName() + " expects labeling Geo Time Series to be non empty.");
            }
            String cls = ((GeoTimeSerie)o).getName();
            if (classes.add(cls)) continue;
            throw new WarpScriptException(this.getName() + " labeling Geo Time Series must all have different class names.");
        }
        top = stack.pop();
        if (!(top instanceof List) || 0 == ((List)top).size()) {
            throw new WarpScriptException(this.getName() + " operates on a non empty list of Geo Time Series or GTS Encoders.");
        }
        List paramGts = (List)top;
        ArrayList gts = new ArrayList(paramGts.size());
        for (Object o : paramGts) {
            if (o instanceof GTSEncoder) {
                GTSEncoder encoder = (GTSEncoder)o;
                GTSDecoder decoder = encoder.getDecoder(true);
                try {
                    o = decoder.decode(null, true);
                }
                catch (Throwable t) {
                    throw new WarpScriptException(this.getName() + " encountered an error while decoding encoder.", t);
                }
            }
            if (!(o instanceof GeoTimeSerie)) {
                throw new WarpScriptException(this.getName() + " operates on a list Geo Time Series or GTS Encoders.");
            }
            gts.add(o);
            GeoTimeSerie g = (GeoTimeSerie)o;
            if (0 == GTSHelper.nvalues(g)) {
                throw new WarpScriptException(this.getName() + " operates on non empty Geo Time Series or GTS Encoders.");
            }
            for (String key : g.getLabels().keySet()) {
                if (!classes.contains(key)) continue;
                throw new WarpScriptException(this.getName() + " labeling class '" + key + "' is already a label of a Geo Time Series or GTS Encoder to label.");
            }
        }
        for (Object g : gts) {
            GTSHelper.sort((GeoTimeSerie)g);
        }
        for (Object g : labeling) {
            GTSHelper.sort((GeoTimeSerie)g);
        }
        int[] labelingIndices = new int[labeling.size()];
        int[] gtsIndices = new int[gts.size()];
        boolean done = false;
        HashMap<HashMap<String, String>, GeoTimeSerie> labeled = new HashMap<HashMap<String, String>, GeoTimeSerie>();
        long commonts = Long.MAX_VALUE;
        if (this.synchronous) {
            commonts = GTSHelper.tickAtIndex((GeoTimeSerie)labeling.get(0), 0);
        } else {
            for (int i = 0; i < labelingIndices.length; ++i) {
                if (GTSHelper.tickAtIndex((GeoTimeSerie)labeling.get(i), 0) >= commonts) continue;
                commonts = GTSHelper.tickAtIndex((GeoTimeSerie)labeling.get(i), 0);
            }
        }
        while (!done) {
            int i;
            int i2;
            boolean skip = false;
            if (this.synchronous) {
                for (int i3 = 0; i3 < labelingIndices.length; ++i3) {
                    GeoTimeSerie g = (GeoTimeSerie)labeling.get(i3);
                    int n = GTSHelper.nvalues(g);
                    while (labelingIndices[i3] < n && GTSHelper.tickAtIndex(g, labelingIndices[i3]) < commonts) {
                        int n2 = i3;
                        labelingIndices[n2] = labelingIndices[n2] + 1;
                    }
                    if (labelingIndices[i3] >= n) {
                        done = true;
                        skip = true;
                        break;
                    }
                    if (GTSHelper.tickAtIndex(g, labelingIndices[i3]) <= commonts) continue;
                    commonts = GTSHelper.tickAtIndex(g, labelingIndices[i3]);
                    skip = true;
                    break;
                }
                if (skip) continue;
            }
            HashMap<String, String> labels = new HashMap<String, String>();
            for (i2 = 0; i2 < labelingIndices.length; ++i2) {
                GeoTimeSerie g = (GeoTimeSerie)labeling.get(i2);
                if (commonts != GTSHelper.tickAtIndex(g, labelingIndices[i2])) continue;
                String key = g.getName();
                String value = String.valueOf(GTSHelper.valueAtIndex(g, labelingIndices[i2]));
                labels.put(key, value);
            }
            for (i2 = 0; i2 < gtsIndices.length; ++i2) {
                GeoTimeSerie target;
                HashMap<String, String> gtsLabels;
                GeoTimeSerie g = (GeoTimeSerie)gts.get(i2);
                int n = GTSHelper.nvalues(g);
                if (this.synchronous) {
                    while (gtsIndices[i2] < n && GTSHelper.tickAtIndex(g, gtsIndices[i2]) < commonts) {
                        int n3 = i2;
                        gtsIndices[n3] = gtsIndices[n3] + 1;
                    }
                    if (gtsIndices[i2] >= n || GTSHelper.tickAtIndex(g, gtsIndices[i2]) > commonts) continue;
                    gtsLabels = new HashMap<String, String>(g.getLabels());
                    gtsLabels.putAll(labels);
                    gtsLabels.put(null, g.getName());
                    target = (GeoTimeSerie)labeled.get(gtsLabels);
                    if (null == target) {
                        target = new GeoTimeSerie();
                        target.setName(g.getName());
                        target.setLabels(gtsLabels);
                        target.getMetadata().setAttributes(g.getMetadata().getAttributes());
                        labeled.put(gtsLabels, target);
                    }
                    while (gtsIndices[i2] < n && commonts == GTSHelper.tickAtIndex(g, gtsIndices[i2])) {
                        GTSHelper.setValue(target, commonts, GTSHelper.locationAtIndex(g, gtsIndices[i2]), GTSHelper.elevationAtIndex(g, gtsIndices[i2]), GTSHelper.valueAtIndex(g, gtsIndices[i2]), false);
                        int n4 = i2;
                        gtsIndices[n4] = gtsIndices[n4] + 1;
                    }
                    continue;
                }
                while (gtsIndices[i2] < n && GTSHelper.tickAtIndex(g, gtsIndices[i2]) < commonts) {
                    gtsLabels = new HashMap<String, String>(g.getLabels());
                    gtsLabels.put(null, g.getName());
                    target = (GeoTimeSerie)labeled.get(gtsLabels);
                    if (null == target) {
                        target = new GeoTimeSerie();
                        target.setName(g.getName());
                        target.setLabels(gtsLabels);
                        target.getMetadata().setAttributes(g.getMetadata().getAttributes());
                        labeled.put(gtsLabels, target);
                    }
                    GTSHelper.setValue(target, GTSHelper.tickAtIndex(g, gtsIndices[i2]), GTSHelper.locationAtIndex(g, gtsIndices[i2]), GTSHelper.elevationAtIndex(g, gtsIndices[i2]), GTSHelper.valueAtIndex(g, gtsIndices[i2]), false);
                    int n5 = i2;
                    gtsIndices[n5] = gtsIndices[n5] + 1;
                }
                if (gtsIndices[i2] >= n || GTSHelper.tickAtIndex(g, gtsIndices[i2]) > commonts) continue;
                gtsLabels = new HashMap<String, String>(g.getLabels());
                gtsLabels.putAll(labels);
                gtsLabels.put(null, g.getName());
                target = (GeoTimeSerie)labeled.get(gtsLabels);
                if (null == target) {
                    target = new GeoTimeSerie();
                    target.setName(g.getName());
                    target.setLabels(gtsLabels);
                    target.getMetadata().setAttributes(g.getMetadata().getAttributes());
                    labeled.put(gtsLabels, target);
                }
                while (gtsIndices[i2] < n && commonts == GTSHelper.tickAtIndex(g, gtsIndices[i2])) {
                    GTSHelper.setValue(target, commonts, GTSHelper.locationAtIndex(g, gtsIndices[i2]), GTSHelper.elevationAtIndex(g, gtsIndices[i2]), GTSHelper.valueAtIndex(g, gtsIndices[i2]), false);
                    int n6 = i2;
                    gtsIndices[n6] = gtsIndices[n6] + 1;
                }
            }
            if (this.synchronous) {
                labelingIndices[0] = labelingIndices[0] + 1;
                if (labelingIndices[0] >= GTSHelper.nvalues((GeoTimeSerie)labeling.get(0))) {
                    done = true;
                    continue;
                }
                commonts = GTSHelper.tickAtIndex((GeoTimeSerie)labeling.get(0), labelingIndices[0]);
                continue;
            }
            long newcommonts = Long.MAX_VALUE;
            done = true;
            for (i = 0; i < labelingIndices.length; ++i) {
                GeoTimeSerie g = (GeoTimeSerie)labeling.get(i);
                if (labelingIndices[i] >= GTSHelper.nvalues(g)) continue;
                if (commonts == GTSHelper.tickAtIndex(g, labelingIndices[i])) {
                    int n = i;
                    labelingIndices[n] = labelingIndices[n] + 1;
                }
                if (GTSHelper.tickAtIndex(g, labelingIndices[i]) < newcommonts) {
                    newcommonts = GTSHelper.tickAtIndex(g, labelingIndices[i]);
                }
                done = false;
            }
            if (done) {
                for (i = 0; i < gtsIndices.length; ++i) {
                    if (gtsIndices[i] >= GTSHelper.nvalues((GeoTimeSerie)gts.get(i))) continue;
                    done = false;
                    break;
                }
            }
            commonts = newcommonts;
        }
        ArrayList results = new ArrayList(labeled.values());
        for (GeoTimeSerie g : results) {
            g.getMetadata().getLabels().remove(null);
        }
        stack.push(results);
        return stack;
    }
}

