/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.TYPEOF;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;

public class PGPRING
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final String TYPEOF_KEYRING = "KEYRING";

    public PGPRING(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (top instanceof PGPSecretKeyRing) {
            try {
                stack.push(((PGPSecretKeyRing)top).getEncoded());
            }
            catch (IOException ioe) {
                throw new WarpScriptException(this.getName() + " error while encoding PGP secret key ring.");
            }
            return stack;
        }
        if (top instanceof PGPPublicKeyRing) {
            try {
                stack.push(((PGPPublicKeyRing)top).getEncoded());
            }
            catch (IOException ioe) {
                throw new WarpScriptException(this.getName() + " error while encoding PGP public key ring.");
            }
            return stack;
        }
        if (!(top instanceof String) && !(top instanceof byte[])) {
            throw new WarpScriptException(this.getName() + " invalid PGP ring, expected STRING or BYTES.");
        }
        byte[] blob = top instanceof String ? ((String)top).getBytes(StandardCharsets.UTF_8) : (byte[])top;
        ByteArrayInputStream in = new ByteArrayInputStream(blob);
        try {
            Object obj;
            InputStream decoderstream = PGPUtil.getDecoderStream((InputStream)in);
            ArrayList<Object> rings = new ArrayList<Object>();
            PGPObjectFactory pgpFact = new PGPObjectFactory(decoderstream, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            while ((obj = pgpFact.nextObject()) != null) {
                if (!(obj instanceof PGPSecretKeyRing) && !(obj instanceof PGPPublicKeyRing)) continue;
                rings.add(obj);
            }
            decoderstream.close();
            stack.push(rings);
        }
        catch (IOException e) {
            throw new WarpScriptException(this.getName() + " error decoding PGP key ring.", e);
        }
        return stack;
    }

    static {
        TYPEOF.addResolver(new TYPEOF.TypeResolver(){

            @Override
            public String typeof(Class c) {
                if (c.isAssignableFrom(PGPSecretKeyRing.class) || c.isAssignableFrom(PGPPublicKeyRing.class)) {
                    return PGPRING.TYPEOF_KEYRING;
                }
                return null;
            }
        });
    }
}

