/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;

public class PGPPRIVATE
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public PGPPRIVATE(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof PGPSecretKeyRing)) {
            throw new WarpScriptException(this.getName() + " expected a PGP secret key ring.");
        }
        PGPSecretKeyRing keyring = (PGPSecretKeyRing)top;
        LinkedHashSet<Long> ids = new LinkedHashSet<Long>();
        Iterator iter = keyring.getSecretKeys();
        while (iter.hasNext()) {
            ids.add(((PGPSecretKey)iter.next()).getKeyID());
        }
        ArrayList<String> keyids = new ArrayList<String>(ids.size());
        for (Long id : ids) {
            String keyid = "000000000000000" + Long.toHexString(id);
            keyids.add(keyid.substring(keyid.length() - 16, keyid.length()).toUpperCase());
        }
        stack.push(keyids);
        return stack;
    }
}

