/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PARTITION
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final boolean strict;

    public PARTITION(String name) {
        super(name);
        this.strict = false;
    }

    public PARTITION(String name, boolean strict) {
        super(name);
        this.strict = strict;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        List bylabels = null;
        try {
            bylabels = (List)top;
        }
        catch (ClassCastException cce) {
            throw new WarpScriptException(this.getName() + " expects a list of labels or null on the top of the stack.", cce);
        }
        top = stack.pop();
        List params = null;
        try {
            params = (List)top;
        }
        catch (ClassCastException cce) {
            throw new WarpScriptException(this.getName() + " expects a list of Geo Time Series instances under the top of the stack.", cce);
        }
        ArrayList<GeoTimeSerie> series = new ArrayList<GeoTimeSerie>();
        for (int i = 0; i < params.size(); ++i) {
            if (params.get(i) instanceof GeoTimeSerie) {
                series.add((GeoTimeSerie)params.get(i));
                continue;
            }
            if (!(params.get(i) instanceof List)) continue;
            for (Object o : (List)params.get(i)) {
                if (!(o instanceof GeoTimeSerie)) {
                    throw new WarpScriptException(this.getName() + " expects a list of Geo Time Series as first parameter.");
                }
                series.add((GeoTimeSerie)o);
            }
        }
        Map<Map<String, String>, List<GeoTimeSerie>> eqclasses = GTSHelper.partition(series, bylabels);
        if (this.strict && null != bylabels) {
            HashMap stricteqclasses = new HashMap();
            for (Map.Entry<Map<String, String>, List<GeoTimeSerie>> entry : eqclasses.entrySet()) {
                Map<String, String> key = entry.getKey();
                HashMap<String, String> newkey = new HashMap<String, String>();
                for (String label : bylabels) {
                    if (null == key.get(label)) continue;
                    newkey.put(label, key.get(label));
                }
                stricteqclasses.put(newkey, entry.getValue());
            }
            stack.push(stricteqclasses);
        } else {
            stack.push(eqclasses);
        }
        return stack;
    }
}

