/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GTSOpsHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.ListRecursiveStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import java.math.BigDecimal;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.LongUnaryOperator;

public class NumericalUnaryFunction
extends ListRecursiveStackFunction {
    final ListRecursiveStackFunction.ElementStackFunction func;
    final GTSOpsHelper.GTSUnaryOp GTSopL;
    final GTSOpsHelper.GTSUnaryOp GTSopD;
    final GTSOpsHelper.GTSUnaryOp GTSopDL;

    public NumericalUnaryFunction(String name, LongUnaryOperator opL, DoubleUnaryOperator opD) {
        this(name, opL, opD, null);
    }

    public NumericalUnaryFunction(String name, final LongUnaryOperator opL, final DoubleUnaryOperator opD, final DoubleToLongFunction opDL) {
        super(name);
        if (null != opD && null != opDL) {
            throw new RuntimeException("Incoherent instantiation parameters for numerical function: " + name);
        }
        this.GTSopL = null == opL || LongUnaryOperator.identity() == opL ? null : new GTSOpsHelper.GTSUnaryOp(){

            @Override
            public Object op(GeoTimeSerie gts, int idx) {
                return opL.applyAsLong(((Number)GTSHelper.valueAtIndex(gts, idx)).longValue());
            }
        };
        this.GTSopD = null == opD || DoubleUnaryOperator.identity() == opD ? null : new GTSOpsHelper.GTSUnaryOp(){

            @Override
            public Object op(GeoTimeSerie gts, int idx) {
                return opD.applyAsDouble(((Number)GTSHelper.valueAtIndex(gts, idx)).doubleValue());
            }
        };
        this.GTSopDL = null == opDL ? null : new GTSOpsHelper.GTSUnaryOp(){

            @Override
            public Object op(GeoTimeSerie gts, int idx) {
                return opDL.applyAsLong(((Number)GTSHelper.valueAtIndex(gts, idx)).doubleValue());
            }
        };
        this.func = new ListRecursiveStackFunction.ElementStackFunction(){

            @Override
            public Object applyOnElement(Object element) throws WarpScriptException {
                if (element instanceof Number) {
                    if (null != opD && (null == opL || element instanceof Double || element instanceof BigDecimal)) {
                        return opD.applyAsDouble(((Number)element).doubleValue());
                    }
                    if (null != opDL && (null == opL || element instanceof Double || element instanceof BigDecimal)) {
                        return opDL.applyAsLong(((Number)element).doubleValue());
                    }
                    return opL.applyAsLong(((Number)element).longValue());
                }
                if (element instanceof GeoTimeSerie) {
                    GeoTimeSerie gts = (GeoTimeSerie)element;
                    GeoTimeSerie.TYPE type = gts.getType();
                    if (GeoTimeSerie.TYPE.LONG != type && GeoTimeSerie.TYPE.DOUBLE != type && GeoTimeSerie.TYPE.UNDEFINED != type) {
                        throw new WarpScriptException(NumericalUnaryFunction.this.getName() + " can only operate on LONG, DOUBLE or empty GTSs.");
                    }
                    GeoTimeSerie result = null;
                    if (null != opD && (null == opL || gts.getType() == GeoTimeSerie.TYPE.DOUBLE)) {
                        if (DoubleUnaryOperator.identity() == opD) {
                            result = gts.clone();
                        } else {
                            result = gts.cloneEmpty(gts.size());
                            GTSOpsHelper.applyUnaryOp(result, gts, NumericalUnaryFunction.this.GTSopD);
                        }
                    } else if (null != opDL && (null == opL || gts.getType() == GeoTimeSerie.TYPE.DOUBLE)) {
                        result = gts.cloneEmpty(gts.size());
                        GTSOpsHelper.applyUnaryOp(result, gts, NumericalUnaryFunction.this.GTSopDL);
                    } else if (LongUnaryOperator.identity() == opL) {
                        result = gts.clone();
                    } else {
                        result = gts.cloneEmpty(gts.size());
                        GTSOpsHelper.applyUnaryOp(result, gts, NumericalUnaryFunction.this.GTSopL);
                    }
                    return result;
                }
                return ListRecursiveStackFunction.UNHANDLED;
            }
        };
    }

    @Override
    public ListRecursiveStackFunction.ElementStackFunction generateFunction(WarpScriptStack stack) throws WarpScriptException {
        return this.func;
    }

    @Override
    public String getUnhandledErrorMessage() {
        return this.getName() + " can only operate on numerical values, list of numerical values or numerical GTSs.";
    }
}

