/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GTSOpsHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.function.DoubleBinaryOperator;
import java.util.function.LongBinaryOperator;

public class NumericalBinaryFunction
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    final LongBinaryOperator opL;
    final DoubleBinaryOperator opD;
    final boolean applyInList;
    final GTSOpsHelper.GTSMixedOp leftGTSopL;
    final GTSOpsHelper.GTSMixedOp leftGTSopD;
    final GTSOpsHelper.GTSMixedOp rightGTSopL;
    final GTSOpsHelper.GTSMixedOp rightGTSopD;
    private final String unhandledErrorMessage;

    public NumericalBinaryFunction(String name, LongBinaryOperator longBinOp, DoubleBinaryOperator doubleBinOp, boolean applyOnSingleList) {
        super(name);
        this.opL = longBinOp;
        this.opD = doubleBinOp;
        this.applyInList = applyOnSingleList;
        this.unhandledErrorMessage = applyOnSingleList ? name + " can only operate on 2 numerical values, or a numerical value and a list of numerical values, or a numerical value and a GTS of numerical values, or a list of numerical values." : name + " can only operate on 2 numerical values, or a numerical value and a list of numerical values, or a numerical value and a GTS of numerical values.";
        this.leftGTSopL = null == this.opL ? null : new GTSOpsHelper.GTSMixedOp(){

            @Override
            public Object op(GeoTimeSerie gts, int idx, Object op0) {
                return NumericalBinaryFunction.this.opL.applyAsLong(((Number)GTSHelper.valueAtIndex(gts, idx)).longValue(), ((Number)op0).longValue());
            }
        };
        this.leftGTSopD = null == this.opD ? null : new GTSOpsHelper.GTSMixedOp(){

            @Override
            public Object op(GeoTimeSerie gts, int idx, Object op0) {
                return NumericalBinaryFunction.this.opD.applyAsDouble(((Number)GTSHelper.valueAtIndex(gts, idx)).doubleValue(), ((Number)op0).doubleValue());
            }
        };
        this.rightGTSopL = null == this.opL ? null : new GTSOpsHelper.GTSMixedOp(){

            @Override
            public Object op(GeoTimeSerie gts, int idx, Object op1) {
                return NumericalBinaryFunction.this.opL.applyAsLong(((Number)op1).longValue(), ((Number)GTSHelper.valueAtIndex(gts, idx)).longValue());
            }
        };
        this.rightGTSopD = null == this.opD ? null : new GTSOpsHelper.GTSMixedOp(){

            @Override
            public Object op(GeoTimeSerie gts, int idx, Object op1) {
                return NumericalBinaryFunction.this.opD.applyAsDouble(((Number)op1).doubleValue(), ((Number)GTSHelper.valueAtIndex(gts, idx)).doubleValue());
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object op0 = stack.pop();
        if (op0 instanceof Number) {
            Object op1 = stack.pop();
            if (op1 instanceof Number) {
                if (null != this.opD && (null == this.opL || op0 instanceof Double || op1 instanceof Double || op0 instanceof BigDecimal || op1 instanceof BigDecimal)) {
                    stack.push(this.opD.applyAsDouble(((Number)op1).doubleValue(), ((Number)op0).doubleValue()));
                    return stack;
                } else {
                    stack.push(this.opL.applyAsLong(((Number)op1).longValue(), ((Number)op0).longValue()));
                }
                return stack;
            } else if (op1 instanceof List) {
                List list = (List)op1;
                ArrayList<Number> result = new ArrayList<Number>(list.size());
                for (Object element : list) {
                    if (!(element instanceof Number)) {
                        throw new WarpScriptException(this.unhandledErrorMessage);
                    }
                    if (null != this.opD && (null == this.opL || op0 instanceof Double || element instanceof Double || op0 instanceof BigDecimal || element instanceof BigDecimal)) {
                        result.add(this.opD.applyAsDouble(((Number)element).doubleValue(), ((Number)op0).doubleValue()));
                        continue;
                    }
                    result.add(this.opL.applyAsLong(((Number)element).longValue(), ((Number)op0).longValue()));
                }
                stack.push(result);
                return stack;
            } else {
                if (!(op1 instanceof GeoTimeSerie)) throw new WarpScriptException(this.unhandledErrorMessage);
                GeoTimeSerie gts = (GeoTimeSerie)op1;
                GeoTimeSerie.TYPE type = gts.getType();
                if (GeoTimeSerie.TYPE.LONG != type && GeoTimeSerie.TYPE.DOUBLE != type && GeoTimeSerie.TYPE.UNDEFINED != type) {
                    throw new WarpScriptException(this.unhandledErrorMessage);
                }
                GeoTimeSerie result = gts.cloneEmpty(gts.size());
                if (null != this.leftGTSopD && (null == this.leftGTSopL || op0 instanceof Double || type == GeoTimeSerie.TYPE.DOUBLE || op0 instanceof BigDecimal)) {
                    GTSOpsHelper.applyUnaryOp(result, gts, this.leftGTSopD, op0);
                } else {
                    GTSOpsHelper.applyUnaryOp(result, gts, this.leftGTSopL, op0);
                }
                stack.push(result);
            }
            return stack;
        } else if (op0 instanceof List) {
            if (this.applyInList) {
                Number result = null;
                for (Object element : (List)op0) {
                    if (!(element instanceof Number)) {
                        throw new WarpScriptException(this.unhandledErrorMessage);
                    }
                    if (null == result) {
                        if (null != this.opD && (null == this.opL || element instanceof Double || element instanceof BigDecimal)) {
                            result = ((Number)element).doubleValue();
                            continue;
                        }
                        result = ((Number)element).longValue();
                        continue;
                    }
                    if (null != this.opD && (null == this.opL || result instanceof Double || element instanceof Double || element instanceof BigDecimal)) {
                        result = this.opD.applyAsDouble(result.doubleValue(), ((Number)element).doubleValue());
                        continue;
                    }
                    result = this.opL.applyAsLong(result.longValue(), ((Number)element).longValue());
                }
                stack.push(result);
                return stack;
            } else {
                Object op1 = stack.pop();
                if (!(op1 instanceof Number)) {
                    throw new WarpScriptException(this.unhandledErrorMessage);
                }
                List list = (List)op0;
                ArrayList<Number> result = new ArrayList<Number>(list.size());
                for (Object element : list) {
                    if (!(element instanceof Number)) {
                        throw new WarpScriptException(this.unhandledErrorMessage);
                    }
                    if (null != this.opD && (null == this.opL || op1 instanceof Double || element instanceof Double || op1 instanceof BigDecimal || element instanceof BigDecimal)) {
                        result.add(this.opD.applyAsDouble(((Number)op1).doubleValue(), ((Number)element).doubleValue()));
                        continue;
                    }
                    result.add(this.opL.applyAsLong(((Number)op1).longValue(), ((Number)element).longValue()));
                }
                stack.push(result);
            }
            return stack;
        } else {
            if (!(op0 instanceof GeoTimeSerie)) throw new WarpScriptException(this.unhandledErrorMessage);
            GeoTimeSerie gts = (GeoTimeSerie)op0;
            GeoTimeSerie.TYPE type = gts.getType();
            if (type != GeoTimeSerie.TYPE.LONG && type != GeoTimeSerie.TYPE.DOUBLE && type != GeoTimeSerie.TYPE.UNDEFINED) {
                throw new WarpScriptException(this.unhandledErrorMessage);
            }
            if (this.applyInList) {
                int n = gts.size();
                if (null != this.opD && (null == this.opL || GeoTimeSerie.TYPE.DOUBLE == type)) {
                    Double result = null;
                    for (int idx = 0; idx < n; ++idx) {
                        Number value = (Number)GTSHelper.valueAtIndex(gts, idx);
                        result = null == result ? Double.valueOf(value.doubleValue()) : Double.valueOf(this.opD.applyAsDouble(result, value.doubleValue()));
                    }
                    stack.push(result);
                    return stack;
                } else {
                    Long result = null;
                    for (int idx = 0; idx < n; ++idx) {
                        Number value = (Number)GTSHelper.valueAtIndex(gts, idx);
                        result = null == result ? Long.valueOf(value.longValue()) : Long.valueOf(this.opL.applyAsLong(result, value.longValue()));
                    }
                    stack.push(result);
                }
                return stack;
            } else {
                Object op1 = stack.pop();
                if (!(op1 instanceof Number)) {
                    throw new WarpScriptException(this.unhandledErrorMessage);
                }
                GeoTimeSerie result = gts.cloneEmpty(gts.size());
                if (null != this.rightGTSopD && (null == this.rightGTSopL || op1 instanceof Double || type == GeoTimeSerie.TYPE.DOUBLE || op1 instanceof BigDecimal)) {
                    GTSOpsHelper.applyUnaryOp(result, gts, this.rightGTSopD, op1);
                } else {
                    GTSOpsHelper.applyUnaryOp(result, gts, this.rightGTSopL, op1);
                }
                stack.push(result);
            }
        }
        return stack;
    }

    public static LongBinaryOperator toLongBinaryOperator(final DoubleBinaryOperator doubleBinaryOperator) {
        return new LongBinaryOperator(){

            @Override
            public long applyAsLong(long l0, long l1) {
                return (long)doubleBinaryOperator.applyAsDouble(l0, l1);
            }
        };
    }
}

