/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class INCLUDE
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final File root;
    private final JarFile jar;
    private final AtomicBoolean enabled;

    public INCLUDE(String name, File root, AtomicBoolean enabled) {
        super(name);
        this.root = root;
        this.jar = null;
        this.enabled = enabled;
    }

    public INCLUDE(String name, JarFile jar, AtomicBoolean enabled) {
        super(name);
        this.root = null;
        this.jar = jar;
        this.enabled = enabled;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        if (!this.enabled.get()) {
            throw new WarpScriptException(this.getName() + " can only be used when loading macros, not when using them.");
        }
        Object top = stack.pop();
        if (!(top instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a macro path on top of the stack.");
        }
        BufferedReader br = null;
        long lineno = 0L;
        try {
            String line;
            InputStreamReader reader = null;
            if (null != this.root) {
                File f = new File(this.root, top.toString());
                String path = f.getAbsolutePath();
                if (!path.startsWith(this.root.getAbsolutePath())) {
                    throw new WarpScriptException(this.getName() + " invalid path.");
                }
                if (!f.exists()) {
                    throw new WarpScriptException(this.getName() + " was unable to load '" + path.substring(this.root.getAbsolutePath().length() + 1) + "'.");
                }
                reader = new FileReader(f);
            } else {
                JarEntry entry = this.jar.getJarEntry(top.toString());
                reader = new InputStreamReader(this.jar.getInputStream(entry));
            }
            br = new BufferedReader(reader);
            while (null != (line = br.readLine())) {
                stack.exec(line, ++lineno);
            }
        }
        catch (Exception e) {
            throw new WarpScriptException(this.getName() + " encountered an error line " + lineno + ".", e);
        }
        finally {
            if (null != br) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
        return stack;
    }
}

