/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.GeneralDigest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;

public class HMAC
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private Class digestAlgo;

    public HMAC(String name, Class<? extends GeneralDigest> digestAlgo) {
        super(name);
        this.digestAlgo = digestAlgo;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof byte[])) {
            throw new WarpScriptException(this.getName() + " expects a byte array (key) on top of the stack.");
        }
        byte[] key = (byte[])top;
        top = stack.pop();
        if (!(top instanceof byte[])) {
            throw new WarpScriptException(this.getName() + " operates on a byte array.");
        }
        byte[] bytes = (byte[])top;
        try {
            HMac m = new HMac((Digest)this.digestAlgo.newInstance());
            m.init((CipherParameters)new KeyParameter(key));
            m.update(bytes, 0, bytes.length);
            byte[] mac = new byte[m.getMacSize()];
            m.doFinal(mac, 0);
            stack.push(mac);
            return stack;
        }
        catch (Exception exp) {
            throw new WarpScriptException(this.getName() + " unable to instantiate message digest", exp);
        }
    }
}

