/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.ThriftUtils;
import io.warp10.continuum.gts.GTSEncoder;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GTSWrapperHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.store.thrift.data.GTSWrapper;
import io.warp10.continuum.store.thrift.data.Metadata;
import io.warp10.crypto.OrderPreservingBase64;
import io.warp10.script.ListRecursiveStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.TreeMap;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;

public class GOLDWRAP
extends ListRecursiveStackFunction {
    private final ListRecursiveStackFunction.ElementStackFunction function = this.generateFunctionOnce(false);
    private final ListRecursiveStackFunction.ElementStackFunction reversedFunction = this.generateFunctionOnce(true);

    public GOLDWRAP(String name) {
        super(name);
    }

    private ListRecursiveStackFunction.ElementStackFunction generateFunctionOnce(final boolean reversed) {
        return new ListRecursiveStackFunction.ElementStackFunction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object applyOnElement(Object element) throws WarpScriptException {
                GTSWrapper wrapper;
                GTSEncoder encoder = null;
                boolean sortedEncoder = false;
                if (element instanceof GeoTimeSerie) {
                    encoder = new GTSEncoder(0L);
                    encoder.setMetadata(((GeoTimeSerie)element).getMetadata());
                    GTSHelper.fullsort((GeoTimeSerie)element, reversed);
                    sortedEncoder = true;
                    encoder.encodeOptimized((GeoTimeSerie)element);
                } else if (element instanceof GTSEncoder) {
                    encoder = (GTSEncoder)element;
                } else if (element instanceof String || element instanceof byte[]) {
                    TDeserializer deser = ThriftUtils.getTDeserializer();
                    byte[] bytes = element instanceof String ? OrderPreservingBase64.decode(element.toString().getBytes(StandardCharsets.US_ASCII)) : (byte[])element;
                    wrapper = new GTSWrapper();
                    deser.deserialize((TBase)wrapper, bytes);
                    encoder = GTSWrapperHelper.fromGTSWrapperToGTSEncoder(wrapper);
                } else {
                    return ListRecursiveStackFunction.UNHANDLED;
                }
                GTSEncoder enc = null;
                enc = sortedEncoder ? encoder : GTSHelper.fullsort(encoder, reversed, 0L);
                Metadata metadata = enc.getRawMetadata();
                enc.setMetadata(new Metadata());
                try {
                    byte[] bytes;
                    TreeMap<String, String> smap;
                    if (metadata.getLabelsSize() > 0) {
                        smap = new TreeMap<String, String>();
                        smap.putAll(metadata.getLabels());
                        enc.getRawMetadata().setLabels(smap);
                    }
                    if (metadata.getAttributesSize() > 0) {
                        smap = new TreeMap();
                        smap.putAll(metadata.getAttributes());
                        enc.getRawMetadata().setAttributes(smap);
                    }
                    enc.getRawMetadata().setName(metadata.getName());
                    wrapper = GTSWrapperHelper.fromGTSEncoderToGTSWrapper(enc, true, 1.0, Integer.MAX_VALUE);
                    TSerializer ser = ThriftUtils.getTSerializer();
                    byte[] byArray = bytes = ser.serialize((TBase)wrapper);
                    enc.safeSetMetadata(metadata);
                    return byArray;
                }
                catch (Throwable throwable) {
                    try {
                        enc.safeSetMetadata(metadata);
                        throw throwable;
                    }
                    catch (TException te) {
                        throw new WarpScriptException(GOLDWRAP.this.getName() + " encountered an error while manipulating GTS Wrapper.", te);
                    }
                    catch (IOException ioe) {
                        throw new WarpScriptException(GOLDWRAP.this.getName() + " encountered an error while manipulating Encoder or GTS Wrapper.", ioe);
                    }
                }
            }
        };
    }

    @Override
    public ListRecursiveStackFunction.ElementStackFunction generateFunction(WarpScriptStack stack) throws WarpScriptException {
        boolean reversed = false;
        if (stack.peek() instanceof Boolean) {
            reversed = Boolean.TRUE.equals(stack.pop());
        }
        if (reversed) {
            return this.reversedFunction;
        }
        return this.function;
    }

    @Override
    public String getUnhandledErrorMessage() {
        return this.getName() + " can only handle GTS, ENCODERs and list thereof.";
    }
}

