/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.geoxp.GeoXPLib;
import gnu.trove.list.array.TLongArrayList;
import io.warp10.ThriftUtils;
import io.warp10.continuum.gts.GTSDecoder;
import io.warp10.continuum.gts.GTSWrapperHelper;
import io.warp10.continuum.store.thrift.data.GTSWrapper;
import io.warp10.crypto.OrderPreservingBase64;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;

public class GEOUNPACK
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public GEOUNPACK(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        GeoXPLib.GeoXPShape shape;
        byte[] serialized;
        Object o = stack.pop();
        if (o instanceof String) {
            serialized = OrderPreservingBase64.decode(o.toString().getBytes(StandardCharsets.US_ASCII));
        } else if (o instanceof byte[]) {
            serialized = (byte[])o;
        } else {
            throw new WarpScriptException(this.getName() + " expects a packed shape on top of the stack.");
        }
        TDeserializer deserializer = ThriftUtils.getTDeserializer();
        GTSWrapper wrapper = new GTSWrapper();
        try {
            deserializer.deserialize((TBase)wrapper, serialized);
        }
        catch (TException te) {
            throw new WarpScriptException(te);
        }
        GTSDecoder decoder = GTSWrapperHelper.fromGTSWrapperToGTSDecoder(wrapper);
        int count = (int)wrapper.getCount();
        long[] cells = new long[count];
        boolean erroneousCount = false;
        int idx = 0;
        while (decoder.next()) {
            long cell = decoder.getTimestamp();
            if (0L == (cell & 0xF000000000000000L)) continue;
            if (idx >= count) {
                erroneousCount = true;
                break;
            }
            cells[idx++] = cell;
        }
        if (erroneousCount) {
            TLongArrayList cellsList = new TLongArrayList(cells.length + 1);
            cellsList.add(cells);
            cellsList.add(decoder.getTimestamp());
            while (decoder.next()) {
                long cell = decoder.getTimestamp();
                if (0L == (cell & 0xF000000000000000L)) continue;
                cellsList.add(cell);
            }
            cellsList.sort();
            long lastCell = 0L;
            int noOfDups = 0;
            for (int i = 0; i < cellsList.size(); ++i) {
                long cell = cellsList.get(i);
                if (i != 0) {
                    if (lastCell == cell) {
                        ++noOfDups;
                    } else if (0 != noOfDups) {
                        cellsList.set(i - noOfDups, cell);
                    }
                }
                lastCell = cell;
            }
            shape = GeoXPLib.fromCells((long[])cellsList.toArray(0, cellsList.size() - noOfDups), (boolean)false);
        } else {
            Arrays.sort(cells, 0, idx);
            long lastCell = 0L;
            int noOfDups = 0;
            for (int i = 0; i < idx; ++i) {
                long cell = cells[i];
                if (i != 0) {
                    if (lastCell == cell) {
                        ++noOfDups;
                    } else if (0 != noOfDups) {
                        cells[i - noOfDups] = cell;
                    }
                }
                lastCell = cell;
            }
            if ((idx -= noOfDups) != cells.length) {
                cells = Arrays.copyOf(cells, idx);
            }
            shape = GeoXPLib.fromCells((long[])cells, (boolean)false);
        }
        stack.push(shape);
        return stack;
    }
}

