/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.ThriftUtils;
import io.warp10.WarpConfig;
import io.warp10.WarpDist;
import io.warp10.WarpURLDecoder;
import io.warp10.continuum.Tokens;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.store.Constants;
import io.warp10.continuum.store.DirectoryClient;
import io.warp10.continuum.store.MetadataIterator;
import io.warp10.continuum.store.thrift.data.DirectoryRequest;
import io.warp10.continuum.store.thrift.data.MetaSet;
import io.warp10.continuum.store.thrift.data.Metadata;
import io.warp10.crypto.CryptoUtils;
import io.warp10.crypto.OrderPreservingBase64;
import io.warp10.quasar.token.thrift.data.ReadToken;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.LISTTO;
import io.warp10.script.functions.PARSESELECTOR;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;

public class FIND
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public static final List<String> DEFAULT_LABELS_PRIORITY;
    private WarpScriptStackFunction listTo = new LISTTO("");
    private final boolean elements;
    private final boolean metaset;
    private byte[] METASETS_KEY;

    public FIND(String name, boolean elements) {
        super(name);
        this.elements = elements;
        this.metaset = false;
        this.METASETS_KEY = null;
    }

    public FIND(String name, boolean elements, boolean metaset) {
        super(name);
        if (elements && metaset) {
            throw new RuntimeException("Invalid parameter combination.");
        }
        this.elements = false;
        this.metaset = metaset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        void var28_42;
        MetadataIterator iter;
        boolean expose;
        DirectoryClient directoryClient;
        long gcount;
        long gskip;
        DirectoryRequest drequest;
        Long quietAfter;
        Long activeAfter;
        MetaSet set;
        boolean hasUUIDFlag;
        block86: {
            ReadToken rtoken;
            if (this.metaset && null == this.METASETS_KEY) {
                Class<FIND> clazz = FIND.class;
                // MONITORENTER : io.warp10.script.functions.FIND.class
                this.METASETS_KEY = WarpDist.getKeyStore().getKey("warp.aes.metasets");
                // MONITOREXIT : clazz
            }
            if (this.metaset && null == this.METASETS_KEY) {
                throw new WarpScriptException(this.getName() + " is disabled, as no key is set in '" + "warp.aes.metasets" + "'.");
            }
            Object top = stack.peek();
            hasUUIDFlag = false;
            boolean mapparams = false;
            if (top instanceof List) {
                Object n;
                if (!this.metaset) {
                    if (3 != ((List)top).size() && 4 != ((List)top).size()) {
                        stack.drop();
                        throw new WarpScriptException(this.getName() + " expects 3 or 4 parameters.");
                    }
                    this.listTo.apply(stack);
                    n = stack.pop();
                    hasUUIDFlag = 4 == ((Number)n).intValue() ? Boolean.TRUE.equals(stack.pop()) : false;
                } else {
                    if (7 != ((List)top).size()) {
                        throw new WarpScriptException(this.getName() + " expects 7 parameters.");
                    }
                    this.listTo.apply(stack);
                    n = stack.pop();
                }
            } else {
                if (!(top instanceof Map)) {
                    if (!this.metaset) throw new WarpScriptException(this.getName() + " expects a list or map of parameters.");
                    throw new WarpScriptException(this.getName() + " expects a list of parameters.");
                }
                if (this.metaset) {
                    throw new WarpScriptException(this.getName() + " expects a list of parameters on top of the stack.");
                }
                mapparams = ((Map)top).containsKey("token") && (((Map)top).containsKey("selectors") || ((Map)top).containsKey("selector") || ((Map)top).containsKey("class") && ((Map)top).containsKey("labels"));
            }
            set = null;
            LinkedHashMap<String, String> labelSelectors = null;
            String classSelector = null;
            String token = null;
            activeAfter = null;
            quietAfter = null;
            drequest = null;
            List order = DEFAULT_LABELS_PRIORITY;
            gskip = 0L;
            gcount = Long.MAX_VALUE;
            boolean mustSort = false;
            if (mapparams) {
                top = stack.pop();
                Map<String, Object> params = this.paramsFromMap((Map)top);
                if (params.get("gskip") instanceof Long) {
                    gskip = (Long)params.get("gskip");
                    mustSort = true;
                }
                if (params.get("gcount") instanceof Long) {
                    gcount = (Long)params.get("gcount");
                    mustSort = true;
                }
                if (params.containsKey("selpairs")) {
                    List selectors = (List)params.get("selpairs");
                    drequest = new DirectoryRequest();
                    drequest.setSorted(mustSort);
                    for (int i = 0; i < selectors.size(); ++i) {
                        String csel = (String)((Pair)selectors.get(i)).getLeft();
                        Map lsel = (Map)((Pair)selectors.get(i)).getRight();
                        drequest.addToClassSelectors(csel);
                        drequest.addToLabelsSelectors(lsel);
                    }
                } else {
                    if (!params.containsKey("class")) throw new WarpScriptException(this.getName() + " missing parameters '" + "class" + "', '" + "labels" + "', '" + "selector" + "' or '" + "selectors" + "'.");
                    if (!params.containsKey("labels")) throw new WarpScriptException(this.getName() + " missing parameters '" + "class" + "', '" + "labels" + "', '" + "selector" + "' or '" + "selectors" + "'.");
                    classSelector = (String)params.get("class");
                    labelSelectors = new LinkedHashMap((Map)params.get("labels"));
                }
                token = (String)params.get("token");
                activeAfter = (Long)params.get("active.after");
                quietAfter = (Long)params.get("quiet.after");
                if (params.containsKey("priority")) {
                    order = (List)params.get("priority");
                }
            } else {
                Object oLabelsSelector;
                if (this.metaset) {
                    set = new MetaSet();
                    top = stack.pop();
                    if (!(top instanceof Long)) {
                        throw new WarpScriptException(this.getName() + " expects a metaset TTL (in time units) on top of the stack.");
                    }
                    set.setExpiry(System.currentTimeMillis() + (Long)top / Constants.TIME_UNITS_PER_MS);
                    top = stack.pop();
                    if (!(top instanceof Long)) {
                        if (!(top instanceof Double)) throw new WarpScriptException(this.getName() + " expects a maximum duration or NaN below the expiration.");
                        if (!Double.isNaN((Double)top)) {
                            throw new WarpScriptException(this.getName() + " expects a maximum duration or NaN below the expiration.");
                        }
                    }
                    if (top instanceof Long) {
                        set.setMaxduration((Long)top);
                    }
                    if (!((top = stack.pop()) instanceof Long)) {
                        if (!(top instanceof Double)) throw new WarpScriptException(this.getName() + " expects a 'notafter' parameter below the maximum duration.");
                        if (!Double.isNaN((Double)top)) {
                            throw new WarpScriptException(this.getName() + " expects a 'notafter' parameter below the maximum duration.");
                        }
                    }
                    if (top instanceof Long) {
                        set.setNotafter((Long)top);
                    }
                    if (!((top = stack.pop()) instanceof Long)) {
                        if (!(top instanceof Double)) throw new WarpScriptException(this.getName() + " expects a 'notbefore' parameter below 'notafter'.");
                        if (!Double.isNaN((Double)top)) {
                            throw new WarpScriptException(this.getName() + " expects a 'notbefore' parameter below 'notafter'.");
                        }
                    }
                    if (top instanceof Long) {
                        set.setNotbefore((Long)top);
                    }
                }
                if (!((oLabelsSelector = stack.pop()) instanceof Map)) {
                    throw new WarpScriptException("Label selectors must be a map.");
                }
                labelSelectors = new LinkedHashMap<String, String>((Map)oLabelsSelector);
                Object oClassSelector = stack.pop();
                if (!(oClassSelector instanceof String)) {
                    throw new WarpScriptException("Class selector must be a string.");
                }
                classSelector = (String)oClassSelector;
                Object oToken = stack.pop();
                if (!(oToken instanceof String)) {
                    throw new WarpScriptException("Token must be a string.");
                }
                token = (String)oToken;
            }
            directoryClient = stack.getDirectoryClient();
            try {
                rtoken = Tokens.extractReadToken(token);
                Map<String, String> rtokenAttributes = rtoken.getAttributes();
                if (null != rtokenAttributes) {
                    if (rtokenAttributes.containsKey(".nofind")) {
                        throw new WarpScriptException("Token cannot be used for finding metadata.");
                    }
                    if (this.metaset && rtokenAttributes.containsKey(".nofetch")) {
                        throw new WarpScriptException("Token cannot be used for fetching data.");
                    }
                }
            }
            catch (WarpScriptException wse) {
                throw new WarpScriptException(this.getName() + " given an invalid token.", wse);
            }
            expose = rtoken.getAttributesSize() > 0 && rtoken.getAttributes().containsKey(".expose");
            ArrayList<String> clsSels = new ArrayList<String>();
            ArrayList<Map<String, String>> lblsSels = new ArrayList<Map<String, String>>();
            if (null != labelSelectors && null != classSelector) {
                labelSelectors.remove(".producer");
                labelSelectors.remove(".owner");
                labelSelectors.remove(".app");
                labelSelectors.putAll(Tokens.labelSelectorsFromReadToken(rtoken));
                clsSels.add(classSelector);
                LinkedHashMap ordered = new LinkedHashMap(labelSelectors.size() > 0 ? labelSelectors.size() : 1);
                for (String string : order) {
                    if (!labelSelectors.containsKey(string)) continue;
                    ordered.put(string, labelSelectors.get(string));
                }
                for (Map.Entry entry : labelSelectors.entrySet()) {
                    if (order.contains(entry.getKey())) continue;
                    ordered.put((String)entry.getKey(), entry.getValue());
                }
                lblsSels.add(ordered);
            }
            if (this.metaset) {
                set.setToken(token);
            }
            iter = null;
            try {
                if (null == drequest) {
                    drequest = new DirectoryRequest();
                    drequest.setSorted(mustSort);
                    drequest.setClassSelectors(clsSels);
                    drequest.setLabelsSelectors(lblsSels);
                    break block86;
                }
                if (drequest.isSetLabelsSelectors()) {
                    for (int i = 0; i < drequest.getLabelsSelectorsSize(); ++i) {
                        Map<String, String> map = drequest.getLabelsSelectors().get(i);
                        map.remove(".producer");
                        map.remove(".owner");
                        map.remove(".app");
                        map.putAll(Tokens.labelSelectorsFromReadToken(rtoken));
                        LinkedHashMap<String, String> ordered = new LinkedHashMap<String, String>(map.size());
                        for (String string : order) {
                            if (!map.containsKey(string)) continue;
                            ordered.put(string, map.get(string));
                        }
                        for (Map.Entry entry : map.entrySet()) {
                            if (order.contains(entry.getKey())) continue;
                            ordered.put((String)entry.getKey(), (String)entry.getValue());
                        }
                        drequest.getLabelsSelectors().set(i, ordered);
                    }
                }
            }
            catch (Exception e) {
                throw new WarpScriptException(e);
            }
        }
        if (null != activeAfter) {
            drequest.setActiveAfter(activeAfter);
        }
        if (null != quietAfter) {
            drequest.setQuietAfter(quietAfter);
        }
        iter = directoryClient.iterator(drequest);
        long gtsLimit = (Long)stack.getAttribute("gts.limit");
        AtomicLong gtscount = (AtomicLong)stack.getAttribute("gts.count");
        ArrayList<GeoTimeSerie> series = null;
        Object var28_40 = null;
        LinkedHashMap<Object, HashSet<Object>> labels = null;
        LinkedHashMap<Object, HashSet<Object>> attributes = null;
        if (!this.elements) {
            if (!this.metaset) {
                series = new ArrayList<GeoTimeSerie>();
            }
        } else {
            HashSet hashSet = new HashSet();
            labels = new LinkedHashMap<Object, HashSet<Object>>();
            attributes = new LinkedHashMap<Object, HashSet<Object>>();
        }
        try {
            Thread thread = Thread.currentThread();
            while (iter.hasNext() && !thread.isInterrupted() && gcount > 0L) {
                Metadata metadata = (Metadata)iter.next();
                if (gskip > 0L) {
                    --gskip;
                    continue;
                }
                --gcount;
                if (this.elements) {
                    Set<Object> values;
                    var28_42.add(metadata.getName());
                    if (metadata.getLabelsSize() > 0) {
                        for (Map.Entry<Object, Object> entry : metadata.getLabels().entrySet()) {
                            values = (HashSet<Object>)labels.get(entry.getKey());
                            if (null == values) {
                                values = new HashSet<Object>();
                                labels.put(entry.getKey(), (HashSet<Object>)values);
                            }
                            values.add(entry.getValue());
                        }
                    }
                    if (metadata.getAttributesSize() <= 0) continue;
                    for (Map.Entry<Object, Object> entry : metadata.getAttributes().entrySet()) {
                        values = (Set)attributes.get(entry.getKey());
                        if (null == values) {
                            values = new HashSet();
                            attributes.put(entry.getKey(), (HashSet<Object>)values);
                        }
                        values.add(entry.getValue());
                    }
                    continue;
                }
                if (gtscount.incrementAndGet() > gtsLimit) {
                    throw new WarpScriptException(this.getName() + " exceeded limit of " + gtsLimit + " Geo Time Series, current count is " + gtscount.get() + ". Consider raising the limit or using capabilities.");
                }
                stack.handleSignal();
                GeoTimeSerie gts = new GeoTimeSerie();
                gts.safeSetMetadata(metadata);
                if (hasUUIDFlag) {
                    UUID uUID = new UUID(gts.getClassId(), gts.getLabelsId());
                    gts.getMetadata().putToAttributes(".uuid", uUID.toString());
                }
                if (!this.metaset) {
                    LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                    linkedHashMap.putAll(gts.getLabels());
                    if (!Constants.EXPOSE_OWNER_PRODUCER && !expose) {
                        linkedHashMap.remove(".producer");
                        linkedHashMap.remove(".owner");
                    }
                    gts.setLabels(linkedHashMap);
                    series.add(gts);
                    continue;
                }
                set.addToMetadatas(gts.getMetadata());
            }
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            if (iter instanceof MetadataIterator) {
                try {
                    iter.close();
                }
                catch (Exception thread) {}
            }
        }
        if (!this.elements) {
            if (!this.metaset) {
                stack.push(series);
                return stack;
            }
            List<Metadata> metas = set.getMetadatas();
            if (null == metas) throw new WarpScriptException(this.getName() + " couldn't find any metadata matching the given class and label selectors.");
            if (metas.isEmpty()) {
                throw new WarpScriptException(this.getName() + " couldn't find any metadata matching the given class and label selectors.");
            }
            TSerializer serializer = ThriftUtils.getTSerializer();
            try {
                byte[] serialized = serializer.serialize((TBase)set);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                GZIPOutputStream out = new GZIPOutputStream(byteArrayOutputStream);
                out.write(serialized);
                out.close();
                byte[] compressed = byteArrayOutputStream.toByteArray();
                byte[] wrapped = CryptoUtils.wrap(this.METASETS_KEY, compressed);
                stack.push(new String(OrderPreservingBase64.encode(wrapped), StandardCharsets.UTF_8));
                return stack;
            }
            catch (IOException | TException e) {
                throw new WarpScriptException(this.getName() + " unable to build MetaSet.", e);
            }
        }
        ArrayList list = new ArrayList();
        list.addAll(var28_42);
        stack.push(list);
        HashMap map = new HashMap();
        for (Map.Entry entry : labels.entrySet()) {
            list = new ArrayList();
            list.addAll((Collection)entry.getValue());
            map.put(entry.getKey(), list);
        }
        stack.push(map);
        map = new HashMap();
        Iterator<Map.Entry<Object, Object>> iterator = attributes.entrySet().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                stack.push(map);
                return stack;
            }
            Map.Entry<Object, Object> entry = iterator.next();
            list = new ArrayList();
            list.addAll((Collection)entry.getValue());
            map.put(entry.getKey(), list);
        }
    }

    private Map<String, Object> paramsFromMap(Map<String, Object> map) throws WarpScriptException {
        Object o;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!map.containsKey("token")) {
            throw new WarpScriptException(this.getName() + " Missing '" + "token" + "' parameter");
        }
        params.put("token", map.get("token"));
        if (map.containsKey("selectors")) {
            Object sels = map.get("selectors");
            if (!(sels instanceof List)) {
                throw new WarpScriptException(this.getName() + " Invalid parameter '" + "selectors" + "'");
            }
            ArrayList<Pair> selectors = new ArrayList<Pair>();
            for (Object sel : (List)sels) {
                Object[] clslbls = PARSESELECTOR.parse(sel.toString());
                selectors.add(Pair.of((Object)clslbls[0], (Object)clslbls[1]));
            }
            params.put("selpairs", selectors);
        } else if (map.containsKey("selector")) {
            Object[] clslbls = PARSESELECTOR.parse(map.get("selector").toString());
            params.put("class", clslbls[0]);
            params.put("labels", clslbls[1]);
        } else if (map.containsKey("class") && map.containsKey("labels")) {
            params.put("class", map.get("class"));
            params.put("labels", map.get("labels"));
        }
        if (map.containsKey("active.after")) {
            if (!(map.get("active.after") instanceof Long)) {
                throw new WarpScriptException(this.getName() + " Invalid type for parameter '" + "active.after" + "'.");
            }
            params.put("active.after", (Long)map.get("active.after") / Constants.TIME_UNITS_PER_MS);
        }
        if (map.containsKey("quiet.after")) {
            if (!(map.get("quiet.after") instanceof Long)) {
                throw new WarpScriptException(this.getName() + " Invalid type for parameter '" + "quiet.after" + "'.");
            }
            params.put("quiet.after", (Long)map.get("quiet.after") / Constants.TIME_UNITS_PER_MS);
        }
        if (map.containsKey("priority")) {
            o = map.get("priority");
            if (!(o instanceof List)) {
                throw new WarpScriptException(this.getName() + " Invalid type for parameter '" + "priority" + "', expected a LIST.");
            }
            ArrayList<String> prio = new ArrayList<String>();
            for (Object oo : (List)o) {
                prio.add(String.valueOf(oo));
            }
            params.put("priority", prio);
        }
        if (map.containsKey("gskip")) {
            o = map.get("gskip");
            if (!(o instanceof Long)) {
                throw new WarpScriptException(this.getName() + " Invalid type for parameter '" + "gskip" + "'.");
            }
            long gskip = (Long)o;
            if (gskip < 0L) {
                throw new WarpScriptException(this.getName() + " Parameter '" + "gskip" + "' must be >= 0.");
            }
            params.put("gskip", gskip);
        }
        if (map.containsKey("gcount")) {
            o = map.get("gcount");
            if (!(o instanceof Long)) {
                throw new WarpScriptException(this.getName() + " Invalid type for parameter '" + "gcount" + "'.");
            }
            long gcount = (Long)o;
            if (gcount < 0L) {
                throw new WarpScriptException(this.getName() + " Parameter '" + "gcount" + "' must be >= 0.");
            }
            params.put("gcount", gcount);
        }
        return params;
    }

    static {
        String def = WarpConfig.getProperty("warpscript.labels.priority");
        ArrayList<String> order = new ArrayList<String>();
        if (null != def) {
            String[] tokens;
            for (String token : tokens = def.split(",")) {
                try {
                    token = WarpURLDecoder.decode(token.trim(), StandardCharsets.UTF_8);
                    order.add(token);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        } else {
            order.add(".producer");
            order.add(".app");
            order.add(".owner");
        }
        DEFAULT_LABELS_PRIORITY = Collections.unmodifiableList(order);
    }
}

