/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptFilterFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FILTER
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final boolean flatten;

    public FILTER(String name, boolean flatten) {
        super(name);
        this.flatten = flatten;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof List)) {
            throw new WarpScriptException(this.getName() + " expects a list as input.");
        }
        List params = (List)top;
        if (params.size() < 3) {
            throw new WarpScriptException(this.getName() + " expects at least 3 parameters.");
        }
        for (int i = 0; i < params.size() - 2; ++i) {
            if (params.get(i) instanceof List) continue;
            throw new WarpScriptException(this.getName() + " expects lists of Geo Time Series as first parameters.");
        }
        if (null != params.get(params.size() - 2) && !(params.get(params.size() - 2) instanceof Collection)) {
            throw new WarpScriptException(this.getName() + " expects a list of label names or null as penultimate parameter.");
        }
        if (null != params.get(params.size() - 2)) {
            for (Object o : (Collection)params.get(params.size() - 2)) {
                if (o instanceof String) continue;
                throw new WarpScriptException(this.getName() + " expects a list of label names as penultimate parameter.");
            }
        }
        if (!(params.get(params.size() - 1) instanceof WarpScriptFilterFunction)) {
            throw new WarpScriptException(this.getName() + " expects a filter function as last parameter.");
        }
        List[] colls = new List[params.size() - 2];
        Collection bylabels = (Collection)params.get(params.size() - 2);
        for (int i = 0; i < params.size() - 2; ++i) {
            colls[i] = new ArrayList();
            for (Object o : (List)params.get(i)) {
                if (o instanceof GeoTimeSerie) {
                    colls[i].add((GeoTimeSerie)o);
                    continue;
                }
                throw new WarpScriptException(this.getName() + " expects lists of Geo Time Series as first parameters.");
            }
        }
        if (this.flatten) {
            stack.push(GTSHelper.partitionAndApply(params.get(params.size() - 1), null, null, bylabels, colls));
        } else {
            stack.push(GTSHelper.partitionAndApplyUnflattened(params.get(params.size() - 1), null, null, bylabels, colls));
        }
        return stack;
    }
}

