/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.math.BigInteger;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.math.ec.ECCurve;

public class ECDH
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public ECDH(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof ECPublicKey)) {
            throw new WarpScriptException(this.getName() + " expects an ECC public key.");
        }
        ECPublicKey pubkey = (ECPublicKey)top;
        top = stack.pop();
        if (!(top instanceof ECPrivateKey)) {
            throw new WarpScriptException(this.getName() + " expects an ECC private key.");
        }
        ECPrivateKey key = (ECPrivateKey)top;
        ECCurve curve = key.getParameters().getCurve();
        ECNamedCurveParameterSpec spec = (ECNamedCurveParameterSpec)key.getParameters();
        ECDomainParameters domainParams = new ECDomainParameters(curve, spec.getG(), spec.getN(), spec.getH(), spec.getSeed());
        ECPrivateKeyParameters privateKey = new ECPrivateKeyParameters(key.getD(), domainParams);
        ECPublicKeyParameters publicKey = new ECPublicKeyParameters(pubkey.getQ(), domainParams);
        ECDHBasicAgreement ka = new ECDHBasicAgreement();
        ka.init((CipherParameters)privateKey);
        BigInteger secret = ka.calculateAgreement((CipherParameters)publicKey);
        String hex = secret.toString(16);
        if (0 != hex.length() % 2) {
            hex = "0" + hex;
        }
        stack.push(hex);
        return stack;
    }
}

