/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.GTSStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DOUBLEEXPONENTIALSMOOTHING
extends GTSStackFunction {
    private static final String ALPHA = "alpha";
    private static final String BETA = "beta";

    public DOUBLEEXPONENTIALSMOOTHING(String name) {
        super(name);
    }

    @Override
    protected List<GeoTimeSerie> gtsOp(Map<String, Object> params, GeoTimeSerie gts) throws WarpScriptException {
        return GTSHelper.doubleExponentialSmoothing(gts, (Double)params.get(ALPHA), (Double)params.get(BETA));
    }

    @Override
    protected Map<String, Object> retrieveParameters(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof Number)) {
            throw new WarpScriptException(this.getName() + " expects the 'beta' parameter (trend factor) on the top of the stack.");
        }
        double beta = ((Number)top).doubleValue();
        top = stack.pop();
        if (!(top instanceof Number)) {
            throw new WarpScriptException(this.getName() + " expects the 'alpha' parameter (smoothing factor) at the second level of the stack.");
        }
        double alpha = ((Number)top).doubleValue();
        if (alpha <= 0.0 || alpha >= 1.0) {
            throw new WarpScriptException("'alpha' (smoothing factor) should be strictly between 0.0 and 1.0.");
        }
        if (beta <= 0.0 || beta >= 1.0) {
            throw new WarpScriptException("'beta' (trend factor) should be strictly between 0.0 and 1.0.");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(ALPHA, alpha);
        params.put(BETA, beta);
        return params;
    }
}

