/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.Revision;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;

public class CHECKREV
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final boolean min;

    public CHECKREV(String name, boolean min) {
        super(name);
        this.min = min;
    }

    private static int[] SplitRev(String revision, String errorMessage) throws WarpScriptException {
        if (null == revision || "".equals(revision)) {
            throw new WarpScriptException(errorMessage);
        }
        String[] gitSplit = revision.split("-");
        if (0 == gitSplit.length) {
            throw new WarpScriptException(errorMessage);
        }
        String[] revSplit = gitSplit[0].split("\\.");
        if (0 == revSplit.length) {
            throw new WarpScriptException(errorMessage);
        }
        int[] revIntSplit = new int[revSplit.length];
        for (int revIndex = 0; revIndex < revSplit.length; ++revIndex) {
            try {
                revIntSplit[revIndex] = Integer.valueOf(revSplit[revIndex]);
                continue;
            }
            catch (NumberFormatException nfe) {
                throw new WarpScriptException(errorMessage);
            }
        }
        return revIntSplit;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        if (!(o instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a revision string on top of the stack.");
        }
        if (this.min) {
            stack.push(0 <= CHECKREV.checkRev(this.getName(), (String)o));
        } else {
            stack.push(CHECKREV.checkRev(this.getName(), (String)o) <= 0);
        }
        return stack;
    }

    private static int checkRev(String name, String rev) throws WarpScriptException {
        int[] givenRev = CHECKREV.SplitRev(rev, name + " expects the given revision to be of the form 'X', 'X.Y' or 'X.Y.Z'. X, Y and Z are integers.");
        int[] currentRev = CHECKREV.SplitRev(Revision.REVISION, name + " expects the revision to be set on the platform to a string of the form 'X.Y.Z'. X, Y and Z are integers.");
        int revComp = 0;
        for (int revIndex = 0; revIndex < Math.min(givenRev.length, currentRev.length) && 0 == (revComp = Integer.compare(currentRev[revIndex], givenRev[revIndex])); ++revIndex) {
        }
        if (0 == revComp && givenRev.length > currentRev.length) {
            revComp = -1;
        }
        return revComp;
    }

    public static int checkRev(String rev) throws WarpScriptException {
        return CHECKREV.checkRev("", rev);
    }
}

