/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.google.common.primitives.Bytes;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.TOB58;
import java.math.BigInteger;
import java.util.Arrays;
import org.bouncycastle.crypto.digests.SHA256Digest;

public class B58TO
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final BigInteger[] TEBAHPLA = new BigInteger[123];
    private final boolean check;

    public B58TO(String name, boolean check) {
        super(name);
        this.check = check;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        byte[] decoded;
        Object top = stack.pop();
        byte[] prefix = null;
        if (this.check) {
            if (!(top instanceof byte[])) {
                throw new WarpScriptException(this.getName() + " expects a byte array prefix.");
            }
            prefix = (byte[])top;
            top = stack.pop();
        }
        if (!(top instanceof String)) {
            throw new WarpScriptException(this.getName() + " operates on a STRING.");
        }
        try {
            decoded = B58TO.decode((String)top);
        }
        catch (WarpScriptException wse) {
            throw new WarpScriptException(this.getName() + " encountered an error while decoding Base58.", wse);
        }
        if (this.check) {
            if (decoded.length < prefix.length + 4) {
                throw new WarpScriptException(this.getName() + " Base58 STRING too short.");
            }
            for (int i = 0; i < prefix.length; ++i) {
                if (i <= decoded.length && decoded[i] == prefix[i]) continue;
                throw new WarpScriptException(this.getName() + " invalid prefix.");
            }
            SHA256Digest digest = new SHA256Digest();
            digest.update(decoded, 0, decoded.length - 4);
            byte[] hash = new byte[digest.getDigestSize()];
            digest.doFinal(hash, 0);
            digest.reset();
            digest.update(hash, 0, hash.length);
            digest.doFinal(hash, 0);
            for (int i = 0; i < 4; ++i) {
                if (hash[i] == decoded[decoded.length - 4 + i]) continue;
                throw new WarpScriptException(this.getName() + " invalid checksum.");
            }
            byte[] data = new byte[decoded.length - prefix.length - 4];
            System.arraycopy(decoded, prefix.length, data, 0, data.length);
            decoded = data;
        }
        stack.push(decoded);
        return stack;
    }

    public static byte[] decode(String encoded) throws WarpScriptException {
        int zero_counter;
        for (zero_counter = 0; zero_counter < encoded.length() && '1' == encoded.charAt(zero_counter); ++zero_counter) {
        }
        BigInteger n = BigInteger.ZERO;
        for (int i = zero_counter; i < encoded.length(); ++i) {
            char c = encoded.charAt(i);
            if (c > '\u007f' || null == TEBAHPLA[c]) {
                throw new WarpScriptException("Invalid input '" + encoded.charAt(i) + "' at position " + i + ".");
            }
            n = n.multiply(TOB58.FIFTY_EIGHT).add(TEBAHPLA[c]);
        }
        byte[] nbytes = n.toByteArray();
        if (0 == nbytes[0]) {
            nbytes = Arrays.copyOfRange(nbytes, 1, nbytes.length);
        }
        return Bytes.concat((byte[][])new byte[][]{new byte[zero_counter], nbytes});
    }

    static {
        for (int i = 0; i < "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz".length(); ++i) {
            B58TO.TEBAHPLA["123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz".charAt((int)i)] = BigInteger.valueOf(i);
        }
    }
}

