/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.warp.sdk.Capabilities;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.bouncycastle.crypto.generators.Argon2BytesGenerator;
import org.bouncycastle.crypto.params.Argon2Parameters;

public class ARGON2
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final String KEY_ITERATIONS = "iterations";
    private static final String KEY_MEMORY = "memory";
    private static final String KEY_PARALLELISM = "parallelism";
    private static final String KEY_SECRET = "secret";
    private static final String KEY_SALT = "salt";
    private static final String KEY_ADDITIONAL = "additional";
    private static final String KEY_SIZE = "size";
    private static final String KEY_PASSWORD = "password";
    private static final String KEY_TYPE = "type";
    private static final String CAP_ARGON2_MAXITER = "argon2.maxiter";
    private static final String CAP_ARGON2_MAXPAR = "argon2.maxpar";
    private static final String CAP_ARGON2_MAXMEM = "argon2.maxmem";
    private static final String CAP_ARGON2_MAXSIZE = "argon2.maxsize";
    private static final int MAXITER_DEFAULT = 3;
    private static final int MAXPAR_DEFAULT = 1;
    private static final int MAXMEM_DEFAULT = 32;
    private static final int MAXSIZE_DEFAULT = 32;

    public ARGON2(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof Map)) {
            throw new WarpScriptException(this.getName() + " expects a parameter map.");
        }
        Map map = (Map)top;
        int type = 2;
        if ("i".equalsIgnoreCase(String.valueOf(map.get(KEY_TYPE)))) {
            type = 1;
        } else if ("d".equalsIgnoreCase(String.valueOf(map.get(KEY_TYPE)))) {
            type = 0;
        } else if ("id".equalsIgnoreCase(String.valueOf(map.get(KEY_TYPE)))) {
            type = 2;
        }
        int version = 19;
        Argon2Parameters.Builder builder = new Argon2Parameters.Builder(type).withVersion(version);
        if (map.get(KEY_ITERATIONS) instanceof Long) {
            int iterations = ((Long)map.get(KEY_ITERATIONS)).intValue();
            if (iterations > 3) {
                if (null == Capabilities.get(stack, CAP_ARGON2_MAXITER)) {
                    throw new WarpScriptException(this.getName() + " missing capability '" + CAP_ARGON2_MAXITER + "'.");
                }
                if ((long)iterations > Long.parseLong(Capabilities.get(stack, CAP_ARGON2_MAXITER))) {
                    throw new WarpScriptException(this.getName() + " number of iterations exceeds capability value.");
                }
            }
            builder = builder.withIterations(iterations);
        }
        if (map.get(KEY_MEMORY) instanceof Long) {
            int memory = ((Long)map.get(KEY_MEMORY)).intValue();
            if (memory > 32) {
                if (null == Capabilities.get(stack, CAP_ARGON2_MAXMEM)) {
                    throw new WarpScriptException(this.getName() + " missing capability '" + CAP_ARGON2_MAXMEM + "'.");
                }
                if ((long)memory > Long.parseLong(Capabilities.get(stack, CAP_ARGON2_MAXMEM))) {
                    throw new WarpScriptException(this.getName() + " memory exceeds capability value.");
                }
            }
            builder = builder.withMemoryAsKB(memory);
        }
        if (map.get(KEY_PARALLELISM) instanceof Long) {
            int lanes = ((Long)map.get(KEY_PARALLELISM)).intValue();
            if (lanes > 1) {
                if (null == Capabilities.get(stack, CAP_ARGON2_MAXPAR)) {
                    throw new WarpScriptException(this.getName() + " missing capability '" + CAP_ARGON2_MAXPAR + "'.");
                }
                if ((long)lanes > Long.parseLong(Capabilities.get(stack, CAP_ARGON2_MAXPAR))) {
                    throw new WarpScriptException(this.getName() + " lane count exceeds capability value.");
                }
            }
            builder = builder.withParallelism(lanes);
        }
        if (map.get(KEY_SALT) instanceof byte[]) {
            builder = builder.withSalt((byte[])map.get(KEY_SALT));
        }
        if (map.get(KEY_SECRET) instanceof byte[]) {
            builder = builder.withSecret((byte[])map.get(KEY_SECRET));
        }
        if (map.get(KEY_ADDITIONAL) instanceof byte[]) {
            builder = builder.withAdditional((byte[])map.get(KEY_ADDITIONAL));
        }
        int size = 32;
        if (map.get(KEY_SIZE) instanceof Long && (size = ((Long)map.get(KEY_SIZE)).intValue()) > 32) {
            if (null == Capabilities.get(stack, CAP_ARGON2_MAXSIZE)) {
                throw new WarpScriptException(this.getName() + " missing capability '" + CAP_ARGON2_MAXSIZE + "'.");
            }
            if ((long)size > Long.parseLong(Capabilities.get(stack, CAP_ARGON2_MAXSIZE))) {
                throw new WarpScriptException(this.getName() + " requested output size exceeds capability value.");
            }
        }
        byte[] password = null;
        if (map.get(KEY_PASSWORD) instanceof byte[]) {
            password = (byte[])map.get(KEY_PASSWORD);
        } else if (map.get(KEY_PASSWORD) instanceof String) {
            password = ((String)map.get(KEY_PASSWORD)).getBytes(StandardCharsets.UTF_8);
        } else {
            throw new WarpScriptException(this.getName() + " missing password as either STRING or BYTES.");
        }
        byte[] out = new byte[size];
        Argon2BytesGenerator generator = new Argon2BytesGenerator();
        generator.init(builder.build());
        generator.generateBytes(password, out);
        stack.push(out);
        return stack;
    }
}

