/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptNAryFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class APPLY
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final boolean flatten;

    public APPLY(String name, boolean flatten) {
        super(name);
        this.flatten = flatten;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof List)) {
            throw new WarpScriptException(this.getName() + " expects a list as input.");
        }
        List params = (List)top;
        if (params.size() < 3) {
            throw new WarpScriptException(this.getName() + " expects at least 3 parameters.");
        }
        int opidx = -1;
        for (int i = 0; i < params.size(); ++i) {
            if (!(params.get(i) instanceof WarpScriptNAryFunction)) continue;
            opidx = i;
            break;
        }
        if (-1 == opidx) {
            throw new WarpScriptException(this.getName() + " expects an operation in the parameter list.");
        }
        int labelsidx = opidx - 1;
        if (labelsidx < 1 || null != params.get(labelsidx) && !(params.get(labelsidx) instanceof Collection)) {
            throw new WarpScriptException(this.getName() + " expects a list of label names under the operation.");
        }
        if (null != params.get(labelsidx)) {
            for (Object o : (Collection)params.get(labelsidx)) {
                if (o instanceof String) continue;
                throw new WarpScriptException(this.getName() + " expects a list of label names as penultimate parameter.");
            }
        }
        for (int i = 0; i < labelsidx; ++i) {
            if (params.get(i) instanceof List) continue;
            throw new WarpScriptException(this.getName() + " expects lists of Geo Time Series as first parameters.");
        }
        List[] colls = new List[labelsidx];
        Collection bylabels = (Collection)params.get(labelsidx);
        for (int i = 0; i < labelsidx; ++i) {
            colls[i] = new ArrayList();
            for (Object o : (List)params.get(i)) {
                if (o instanceof GeoTimeSerie) {
                    colls[i].add((GeoTimeSerie)o);
                    continue;
                }
                throw new WarpScriptException(this.getName() + " expects lists of Geo Time Series as first parameters.");
            }
        }
        WarpScriptStack.Macro validator = null;
        if (opidx < params.size() - 1 && params.get(opidx + 1) instanceof WarpScriptStack.Macro) {
            validator = (WarpScriptStack.Macro)params.get(opidx + 1);
        }
        if (this.flatten) {
            stack.push(GTSHelper.partitionAndApply(params.get(opidx), stack, validator, bylabels, colls));
        } else {
            stack.push(GTSHelper.partitionAndApplyUnflattened(params.get(opidx), stack, validator, bylabels, colls));
        }
        return stack;
    }
}

