/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.filter;

import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.StackUtils;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptFilterFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FilterBySize
extends NamedWarpScriptFunction
implements WarpScriptFilterFunction {
    private final int min;
    private final int max;

    public FilterBySize(String name, int min, int max) throws WarpScriptException {
        super(name);
        this.min = min;
        this.max = max;
    }

    @Override
    public List<GeoTimeSerie> filter(Map<String, String> labels, List<GeoTimeSerie> ... series) throws WarpScriptException {
        ArrayList<GeoTimeSerie> retained = new ArrayList<GeoTimeSerie>();
        for (List<GeoTimeSerie> serie : series) {
            for (GeoTimeSerie gts : serie) {
                if (gts.size() < this.min || gts.size() > this.max) continue;
                retained.add(gts);
            }
        }
        return retained;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(StackUtils.toString(this.min));
        sb.append(" ");
        sb.append(StackUtils.toString(this.max));
        sb.append(" ");
        sb.append(this.getName());
        return sb.toString();
    }

    public static class Builder
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        public Builder(String name) {
            super(name);
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            Object o2 = stack.pop();
            Object o1 = stack.pop();
            if (!(o1 instanceof Long) || !(o2 instanceof Long)) {
                throw new WarpScriptException(this.getName() + " expects two LONG objects as arguments.");
            }
            stack.push(new FilterBySize(this.getName(), ((Long)o1).intValue(), ((Long)o2).intValue()));
            return stack;
        }
    }
}

