/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.filler;

import com.geoxp.GeoXPLib;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptFillerFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.SNAPSHOT;
import java.util.List;

public class FillerValue
extends NamedWarpScriptFunction
implements WarpScriptFillerFunction,
SNAPSHOT.Snapshotable {
    private long latlon;
    private long elev;
    private Object value;

    public FillerValue(String name, long latlon, long elev, Object value) throws WarpScriptException {
        super(name);
        if (!(value instanceof Long || value instanceof Double || value instanceof Boolean || value instanceof String || value instanceof byte[])) {
            throw new WarpScriptException(this.getName() + " expects the value to be either a LONG, a DOUBLE, a BOOLEAN, a STRING or a BYTEARRAY");
        }
        this.latlon = latlon;
        this.elev = elev;
        this.value = value;
    }

    @Override
    public Object[] apply(Object[] args) throws WarpScriptException {
        Object[] results = new Object[4];
        Object[] other = (Object[])args[1];
        long tick = ((Number)other[0]).longValue();
        results[0] = tick;
        results[1] = this.latlon;
        results[2] = this.elev;
        results[3] = this.value;
        return results;
    }

    @Override
    public int getPostWindow() {
        return 0;
    }

    @Override
    public int getPreWindow() {
        return 0;
    }

    @Override
    public String snapshot() {
        double[] tuple = GeoXPLib.fromGeoXPPoint((long)this.latlon);
        double lat = tuple[0];
        double lon = tuple[1];
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("[");
            sb.append(" ");
            SNAPSHOT.addElement(sb, lat);
            SNAPSHOT.addElement(sb, lon);
            SNAPSHOT.addElement(sb, this.elev);
            SNAPSHOT.addElement(sb, this.value);
            sb.append("]");
        }
        catch (WarpScriptException wse) {
            sb.append("/*");
            sb.append(" Error while snapshoting function " + this.getName());
            sb.append(" ");
            sb.append("*/");
        }
        sb.append(" ");
        sb.append(this.getName());
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.snapshot();
    }

    public static class Builder
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        public Builder(String name) {
            super(name);
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            Object value;
            Object o = stack.pop();
            long latlon = 91480763316633925L;
            long elev = Long.MIN_VALUE;
            if (o instanceof List) {
                List datapoint = (List)o;
                if (datapoint.size() != 4) {
                    throw new WarpScriptException(this.getName() + " expects a LIST of 4 parameters: latitude longitude elevation value");
                }
                if (!(datapoint.get(0) instanceof Number)) {
                    throw new WarpScriptException(this.getName() + " expects the latitude to be a NUMBER");
                }
                if (!(datapoint.get(1) instanceof Number)) {
                    throw new WarpScriptException(this.getName() + " expects the longitude to be a NUMBER");
                }
                if (!(datapoint.get(2) instanceof Long || datapoint.get(2) instanceof Double && ((Double)datapoint.get(2)).isNaN())) {
                    throw new WarpScriptException(this.getName() + " expects the elevation to be a LONG or NAN");
                }
                double lat = ((Number)datapoint.get(0)).doubleValue();
                double lon = ((Number)datapoint.get(1)).doubleValue();
                if (!Double.isNaN(lat) && !Double.isNaN(lon)) {
                    latlon = GeoXPLib.toGeoXPPoint((double)lat, (double)lon);
                }
                if (!(datapoint.get(2) instanceof Double) || !((Double)datapoint.get(2)).isNaN()) {
                    elev = (Long)datapoint.get(2);
                }
                value = datapoint.get(3);
            } else {
                value = o;
            }
            stack.push(new FillerValue(this.getName(), latlon, elev, value));
            return stack;
        }
    }
}

