/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.binary;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GTSOpsHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;

public abstract class BitwiseOperation
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final GTSOpsHelper.GTSBinaryOp op = new GTSOpsHelper.GTSBinaryOp(){

        @Override
        public Object op(GeoTimeSerie gtsa, GeoTimeSerie gtsb, int idxa, int idxb) {
            return BitwiseOperation.this.operator(((Number)GTSHelper.valueAtIndex(gtsa, idxa)).longValue(), ((Number)GTSHelper.valueAtIndex(gtsb, idxb)).longValue());
        }
    };

    public abstract long operator(long var1, long var3);

    public BitwiseOperation(String name) {
        super(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        String exceptionMessage = this.getName() + " can only operate on two long, or two long GTS, or one long GTS and a long.";
        Object op2 = stack.pop();
        Object op1 = stack.pop();
        if (op2 instanceof Long && op1 instanceof Long) {
            stack.push(this.operator((Long)op1, (Long)op2));
            return stack;
        } else if (op1 instanceof GeoTimeSerie && op2 instanceof GeoTimeSerie) {
            GeoTimeSerie gts1 = (GeoTimeSerie)op1;
            GeoTimeSerie gts2 = (GeoTimeSerie)op2;
            if (GeoTimeSerie.TYPE.LONG == gts1.getType() && GeoTimeSerie.TYPE.LONG == gts2.getType()) {
                GeoTimeSerie result = new GeoTimeSerie(Math.max(GTSHelper.nvalues(gts1), GTSHelper.nvalues(gts2)));
                result.setType(GeoTimeSerie.TYPE.LONG);
                GTSOpsHelper.applyBinaryOp(result, gts1, gts2, this.op);
                stack.push(result);
                return stack;
            } else {
                if ((GeoTimeSerie.TYPE.UNDEFINED != gts1.getType() || GeoTimeSerie.TYPE.LONG != gts2.getType()) && (GeoTimeSerie.TYPE.UNDEFINED != gts2.getType() || GeoTimeSerie.TYPE.LONG != gts1.getType())) throw new WarpScriptException(exceptionMessage);
                stack.push(new GeoTimeSerie());
            }
            return stack;
        } else {
            if (!(op1 instanceof GeoTimeSerie) || !(op2 instanceof Long)) throw new WarpScriptException(exceptionMessage);
            GeoTimeSerie gts = (GeoTimeSerie)op1;
            long mask = ((Number)op2).longValue();
            if (GeoTimeSerie.TYPE.LONG == gts.getType()) {
                GeoTimeSerie result = gts.cloneEmpty();
                result.setType(GeoTimeSerie.TYPE.LONG);
                for (int i = 0; i < GTSHelper.nvalues(gts); ++i) {
                    GTSHelper.setValue(result, GTSHelper.tickAtIndex(gts, i), GTSHelper.locationAtIndex(gts, i), GTSHelper.elevationAtIndex(gts, i), this.operator(((Number)GTSHelper.valueAtIndex(gts, i)).longValue(), mask), false);
                }
                stack.push(result);
                return stack;
            } else {
                if (GeoTimeSerie.TYPE.UNDEFINED != gts.getType()) throw new WarpScriptException(exceptionMessage);
                stack.push(gts.cloneEmpty());
            }
        }
        return stack;
    }
}

