/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script;

import io.warp10.continuum.store.DirectoryClient;
import io.warp10.continuum.store.StoreClient;
import io.warp10.script.InformativeEmptyStackException;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptATCException;
import io.warp10.script.WarpScriptAuditStatement;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.SNAPSHOT;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public interface WarpScriptStack {
    public static final int DEFAULT_MAX_RECURSION_LEVEL = 16;
    public static final long DEFAULT_FETCH_LIMIT = 100000L;
    public static final long DEFAULT_GTS_LIMIT = 100000L;
    public static final long DEFAULT_MAX_OPS = 1000L;
    public static final int DEFAULT_MAX_BUCKETS = 1000000;
    public static final int DEFAULT_MAX_GEOCELLS = 10000;
    public static final int DEFAULT_MAX_DEPTH = 1000;
    public static final long DEFAULT_MAX_LOOP_DURATION = 5000L;
    public static final int DEFAULT_MAX_SYMBOLS = 64;
    public static final long DEFAULT_MAX_PIXELS = 1000000L;
    public static final long DEFAULT_MAX_JSON = 0x1400000L;
    public static final long DEFAULT_REGISTERS = 256L;
    public static final String MACRO_START = "<%";
    public static final String MACRO_END = "%>";
    public static final String COMMENT_START = "/*";
    public static final String COMMENT_END = "*/";
    public static final String MULTILINE_START = "<'";
    public static final String MULTILINE_END = "'>";
    public static final String SECURE_SCRIPT_START = "<S";
    public static final String SECURE_SCRIPT_END = "S>";
    public static final String TOP_LEVEL_SECTION = "[TOP]";
    public static final String ATTRIBUTE_IMPORT_RULES = "import.rules";
    public static final String ATTRIBUTE_LINENO = "lineno";
    public static final String ATTRIBUTE_INTERACTIVE_WRITER = "interactive.writer";
    public static final String ATTRIBUTE_INTERACTIVE_JSON = "interactive.json";
    public static final String ATTRIBUTE_INTERACTIVE_ECHO = "interactive.echo";
    public static final String ATTRIBUTE_INTERACTIVE_TIME = "interactive.time";
    public static final String ATTRIBUTE_SECTION_NAME = "section.name";
    public static final String ATTRIBUTE_MACRO_NAME = "macro.name";
    public static final String ATTRIBUTE_INFOMODE = "infomode";
    public static final String ATTRIBUTE_PARSING_ERRORS = "wsaudit.errors";
    public static final String ATTRIBUTE_DEBUG_DEPTH = "debug.depth";
    public static final String ATTRIBUTE_JSON_STRICT = "json.strict";
    public static final String ATTRIBUTE_JSON_PRETTY = "json.pretty";
    public static final String ATTRIBUTE_JSON_MAXSIZE = "json.size.max";
    public static final String ATTRIBUTE_JSON_MAXSIZE_HARD = "json.size.max.hard";
    public static final String ATTRIBUTE_FETCH_LIMIT = "fetch.limit";
    public static final String ATTRIBUTE_FETCH_LIMIT_HARD = "fetch.limit.hard";
    public static final String ATTRIBUTE_GTS_LIMIT = "gts.limit";
    public static final String ATTRIBUTE_GTS_LIMIT_HARD = "gts.limit.hard";
    public static final String ATTRIBUTE_FETCH_COUNT = "fetch.count";
    public static final String ATTRIBUTE_GTS_COUNT = "gts.count";
    public static final String ATTRIBUTE_ELAPSED = "elapsed";
    public static final String ATTRIBUTE_TIMINGS = "timings";
    public static final String ATTRIBUTE_LOOP_MAXDURATION = "loop.maxduration";
    public static final String ATTRIBUTE_LOOP_MAXDURATION_HARD = "loop.maxduration.hard";
    public static final String ATTRIBUTE_RECURSION_MAXDEPTH = "recursion.maxdepth";
    public static final String ATTRIBUTE_RECURSION_MAXDEPTH_HARD = "recursion.maxdepth.hard";
    public static final String ATTRIBUTE_MAX_DEPTH = "stack.maxdepth";
    public static final String ATTRIBUTE_MAX_DEPTH_HARD = "stack.maxdepth.hard";
    public static final String ATTRIBUTE_MAX_OPS = "stack.maxops";
    public static final String ATTRIBUTE_MAX_OPS_HARD = "stack.maxops.hard";
    public static final String ATTRIBUTE_MAX_PIXELS = "stack.maxpixels";
    public static final String ATTRIBUTE_MAX_PIXELS_HARD = "stack.maxpixels.hard";
    public static final String ATTRIBUTE_MAX_BUCKETS = "stack.maxbuckets";
    public static final String ATTRIBUTE_MAX_BUCKETS_HARD = "stack.maxbuckets.hard";
    public static final String ATTRIBUTE_MAX_GEOCELLS = "stack.maxgeocells";
    public static final String ATTRIBUTE_MAX_GEOCELLS_HARD = "stack.maxgeocells.hard";
    public static final String ATTRIBUTE_OPS = "stack.ops";
    public static final String ATTRIBUTE_MAX_SYMBOLS = "stack.symbols";
    public static final String ATTRIBUTE_MAX_SYMBOLS_HARD = "stack.symbols.hard";
    public static final String ATTRIBUTE_SECURE_KEY = "secure.key";
    public static final String ATTRIBUTE_ALLOW_REDEFINED = "allow.redefined";
    public static final String ATTRIBUTE_HADOOP_PROGRESSABLE = "hadoop.progressable";
    public static final String ATTRIBUTE_IN_XEVAL = "in.xeval";
    public static final String ATTRIBUTE_IN_SECURE_MACRO = "in.secure.macro";
    public static final String ATTRIBUTE_MACRO_TTL = "macro.ttl";
    public static final String ATTRIBUTE_EXPORTED_SYMBOLS = "exported.symbols";
    public static final String ATTRIBUTE_HEADERS = "response.headers";
    public static final String ATTRIBUTE_LAST_ERROR = "last.error";
    public static final String ATTRIBUTE_CREATION_TIME = "creation.time";
    public static final String ATTRIBUTE_NAME = "stack.name";
    public static final String ATTRIBUTE_TIMEBOXED = "stack.timeboxed";
    public static final String CAPNAME_RUNNER_RESCHEDULE_MIN_PERIOD = "runner.reschedule.min.period";
    public static final String ATTRIBUTE_RUNNER_RESCHEDULE_PERIOD = "runner.reschedule.period";
    public static final String ATTRIBUTE_RUNNER_RESCHEDULE_TIMESTAMP = "runner.reschedule.timestamp";
    public static final int COUNTER_RETURN_DEPTH = 0;
    public static final String CAPABILITIES_PREFIX = ".cap:";
    public static final String CAPABILITIES_ATTR = "stack.capabilities";
    public static final String CAPABILITY_INVENTORY = "inventory";
    public static final String CAPABILITY_SETMACROCONFIG = "setmacroconfig";
    public static final String CAPABILITY_MANAGER = "manager";
    public static final String CAPABILITY_REPORT = "report";
    public static final String CAPABILITY_DEBUG = "debug";
    public static final String CAPABILITY_WFGET = "wfget";
    public static final String CAPABILITY_WFSET = "wfset";
    public static final String CAPABILITY_HTTP = "http";
    public static final String CAPABILITY_TIMEBOX_MAXTIME = "timebox.maxtime";
    public static final String CAPABILITY_SLEEP_MAXTIME = "sleep.maxtime";
    public static final String CAPABILITY_LEVELDB = "leveldb";
    public static final String CAPABILITY_LEVELDB_ADMIN = "leveldb.admin";
    public static final String CAPABILITY_LEVELDB_CLOSE = "leveldb.close";
    public static final String CAPABILITY_LEVELDB_COMPACT = "leveldb.compact";
    public static final String CAPABILITY_LEVELDB_OPEN = "leveldb.open";
    public static final String CAPABILITY_LEVELDB_REPAIR = "leveldb.repair";
    public static final String CAPABILITY_LEVELDB_SNAPSHOT = "leveldb.snapshot";
    public static final String CAPABILITY_LEVELDB_PURGE = "leveldb.purge";
    public static final String CAPABILITY_LEVELDB_FIND = "leveldb.find";
    public static final String CAPABILITY_LEVELDB_INFO = "leveldb.info";
    public static final String CAPABILITY_LEVELDB_REPORT = "leveldb.report";
    public static final String CAPABILITY_LEVELDB_TIMESTAMP = "leveldb.timestamp";
    public static final String CAPABILITY_LIMITS = "limits";
    public static final String CAPABILITY_LIMIT = "limit";
    public static final String CAPABILITY_MAXBUCKETS = "maxbuckets";
    public static final String CAPABILITY_MAXDEPTH = "maxdepth";
    public static final String CAPABILITY_MAXGEOCELLS = "maxgeocells";
    public static final String CAPABILITY_MAXGTS = "maxgts";
    public static final String CAPABILITY_MAXJSON = "maxjson";
    public static final String CAPABILITY_MAXLOOP = "maxloop";
    public static final String CAPABILITY_MAXOPS = "maxops";
    public static final String CAPABILITY_MAXPIXELS = "maxpixels";
    public static final String CAPABILITY_MAXRECURSION = "maxrecursion";
    public static final String CAPABILITY_MAXSYMBOLS = "maxsymbols";

    public StoreClient getStoreClient();

    public DirectoryClient getDirectoryClient();

    public void push(Object var1) throws WarpScriptException;

    public Object pop() throws InformativeEmptyStackException;

    public Object[] popn() throws WarpScriptException;

    public Object[] popn(int var1) throws WarpScriptException;

    public Object peek() throws InformativeEmptyStackException;

    public Object peekn() throws WarpScriptException;

    public int depth();

    public void reset(int var1) throws WarpScriptException;

    public void swap() throws WarpScriptException;

    public void rot() throws WarpScriptException;

    public void roll() throws WarpScriptException;

    public void rolld() throws WarpScriptException;

    public void pick() throws WarpScriptException;

    public void drop() throws WarpScriptException;

    public void dropn() throws WarpScriptException;

    public void dup() throws WarpScriptException;

    public void dupn() throws WarpScriptException;

    public Object get(int var1) throws WarpScriptException;

    public void execMulti(String var1) throws WarpScriptException;

    public void exec(String var1) throws WarpScriptException;

    public void exec(String var1, long var2) throws WarpScriptException;

    public void clear();

    public void exec(Macro var1) throws WarpScriptException;

    public Object findFunction(String var1) throws WarpScriptException;

    public Macro find(String var1) throws WarpScriptException;

    public void run(String var1) throws WarpScriptException;

    public String dump(int var1);

    public Object load(String var1);

    public void store(String var1, Object var2) throws WarpScriptException;

    public Object load(int var1) throws WarpScriptException;

    public void store(int var1, Object var2) throws WarpScriptException;

    public void forget(String var1);

    public Map<String, Object> getSymbolTable();

    public Object[] getRegisters();

    public Map<String, WarpScriptStackFunction> getDefined();

    public String getUUID();

    public void signal(Signal var1);

    public void handleSignal() throws WarpScriptATCException;

    public Object setAttribute(String var1, Object var2);

    public Object getAttribute(String var1);

    public AtomicLong getCounter(int var1) throws WarpScriptException;

    public void checkBalanced() throws WarpScriptException;

    public void define(String var1, Macro var2);

    public void save() throws WarpScriptException;

    public void restore() throws WarpScriptException;

    public void restore(StackContext var1) throws WarpScriptException;

    public int hide();

    public int hide(int var1);

    public void show();

    public void show(int var1);

    public void macroOpen() throws WarpScriptException;

    public void macroClose() throws WarpScriptException;

    public void auditMode(boolean var1);

    public static class Macro
    implements SNAPSHOT.Snapshotable {
        private boolean secure = false;
        private long fingerprint;
        private String name = null;
        private long expiry = Long.MIN_VALUE;
        private int size = 0;
        private Object[] statements = new Object[16];

        public boolean isExpired() {
            return Long.MIN_VALUE != this.expiry && this.expiry < System.currentTimeMillis();
        }

        public String toString() {
            return this.snapshot();
        }

        public void add(Object o) {
            this.ensureCapacity(1);
            this.statements[this.size++] = o;
        }

        public Object get(int idx) {
            return this.statements[idx];
        }

        public int size() {
            return this.size;
        }

        public void setSize(int size) {
            if (size < this.size && size >= 0) {
                this.size = size;
            }
        }

        public List<Object> statements() {
            return Arrays.asList(this.statements).subList(0, this.size);
        }

        public void addAll(Macro macro) {
            int n = macro.size;
            this.ensureCapacity(n);
            System.arraycopy(macro.statements, 0, this.statements, this.size, n);
            this.size += n;
        }

        public void setSecure(boolean secure) {
            this.secure = secure;
        }

        public void setSecureRecursive(boolean secure) {
            ArrayList<Macro> macros = new ArrayList<Macro>();
            macros.add(this);
            while (!macros.isEmpty()) {
                Macro m = (Macro)macros.remove(0);
                m.setSecure(secure);
                for (Object stmt : m.statements) {
                    if (!(stmt instanceof Macro)) continue;
                    macros.add((Macro)stmt);
                }
            }
        }

        public boolean isSecure() {
            return this.secure;
        }

        public long getFingerprint() {
            return this.fingerprint;
        }

        public void setFingerprint(long fingerprint) {
            this.fingerprint = fingerprint;
        }

        public void setExpiry(long expiry) {
            this.expiry = expiry;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setNameRecursive(String name) {
            ArrayList<Macro> macros = new ArrayList<Macro>();
            macros.add(this);
            while (!macros.isEmpty()) {
                Macro m = (Macro)macros.remove(0);
                if (null != m.getName()) continue;
                m.setName(name);
                for (Object stmt : m.statements) {
                    if (!(stmt instanceof Macro)) continue;
                    macros.add((Macro)stmt);
                }
            }
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String snapshot() {
            return this.snapshot(true);
        }

        public String snapshot(boolean hideSecure) {
            StringBuilder sb = new StringBuilder();
            sb.append(WarpScriptStack.MACRO_START);
            sb.append(" ");
            if (!this.secure || !hideSecure) {
                for (Object o : this.statements()) {
                    try {
                        if (o instanceof Macro) {
                            sb.append(((Macro)o).snapshot(hideSecure));
                            sb.append(" ");
                        } else if (o instanceof WarpScriptStackFunction) {
                            boolean simplified = false;
                            if (o instanceof WarpScriptAuditStatement) {
                                if (WarpScriptAuditStatement.STATEMENT_TYPE.FUNCTION_CALL == ((WarpScriptAuditStatement)o).type && ((WarpScriptAuditStatement)o).statementObject instanceof WarpScriptStackFunction) {
                                    o = ((WarpScriptAuditStatement)o).statementObject;
                                } else {
                                    sb.append(o.toString());
                                    simplified = true;
                                }
                            }
                            String funcSnapshot = o.toString();
                            if (o instanceof NamedWarpScriptFunction) {
                                NamedWarpScriptFunction namedWarpScriptFunction = (NamedWarpScriptFunction)o;
                                String refSnapshot = namedWarpScriptFunction.refSnapshot();
                                String funcName = namedWarpScriptFunction.getName();
                                if (null != refSnapshot && null != funcName) {
                                    StringBuilder curatedFuncName = new StringBuilder();
                                    SNAPSHOT.appendProcessedString(curatedFuncName, funcName);
                                    if (refSnapshot.equals(funcSnapshot) && curatedFuncName.toString().equals(funcName)) {
                                        sb.append(funcName);
                                        simplified = true;
                                    }
                                }
                            }
                            if (!simplified) {
                                sb.append(funcSnapshot);
                                sb.append(" ");
                                sb.append("EVAL");
                            }
                            sb.append(" ");
                        } else {
                            SNAPSHOT.addElement(sb, o);
                        }
                        int idx = sb.length() - 1;
                        if (0 == sb.length()) continue;
                        if (' ' != sb.charAt(idx)) {
                            sb.append(" ");
                            continue;
                        }
                        while (--idx >= 0 && ' ' == sb.charAt(idx)) {
                        }
                        sb.setLength(idx + 2);
                    }
                    catch (WarpScriptException wse) {
                        sb.append(WarpScriptStack.COMMENT_START);
                        sb.append(" Error while snapshoting element of type '" + o.getClass() + "' ");
                        sb.append(WarpScriptStack.COMMENT_END);
                    }
                }
            } else {
                sb.append(WarpScriptStack.COMMENT_START);
                sb.append(" Secure Macro ");
                sb.append(WarpScriptStack.COMMENT_END);
                sb.append(" ");
            }
            sb.append(WarpScriptStack.MACRO_END);
            return sb.toString();
        }

        private void ensureCapacity(int n) {
            if (this.size + n < this.statements.length) {
                return;
            }
            int newlen = n + this.statements.length + (this.statements.length >> 1);
            this.statements = Arrays.copyOf(this.statements, newlen);
        }
    }

    public static class Mark {
    }

    public static class StackContext {
    }

    public static enum Signal {
        STOP,
        KILL;

    }
}

