/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script;

import io.warp10.script.StackUtils;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.LinkedHashMap;
import java.util.Map;

public class WarpScriptAuditStatement
implements WarpScriptStackFunction {
    public static final String KEY_TYPE = "type";
    public static final String KEY_LINE = "line";
    public static final String KEY_POSITION = "position";
    public static final String KEY_POSITION_END = "position.end";
    public static final String KEY_STATEMENT = "statement";
    public STATEMENT_TYPE type;
    public String statement;
    public long lineNumber;
    public int inLinePositionStart;
    public int inLinePositionEnd;
    public Object statementObject;

    public WarpScriptAuditStatement(STATEMENT_TYPE type, Object statementObject, String statement, Long lineNumber, int start) {
        this.type = type;
        this.statement = statement;
        this.lineNumber = lineNumber;
        this.inLinePositionStart = start;
        this.inLinePositionEnd = statement == null ? start : start + statement.length();
        this.statementObject = statementObject;
    }

    public WarpScriptAuditStatement(STATEMENT_TYPE type, Object statementObject, String statement, Long lineNumber, int start, int end) {
        this.type = type;
        this.statement = statement;
        this.lineNumber = lineNumber;
        this.inLinePositionStart = start;
        this.inLinePositionEnd = end;
        this.statementObject = statementObject;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        switch (this.type) {
            case FUNCTION_CALL: {
                if (this.statementObject instanceof WarpScriptStackFunction) {
                    try {
                        ((WarpScriptStackFunction)this.statementObject).apply(stack);
                        break;
                    }
                    catch (WarpScriptException e) {
                        throw new WarpScriptException("Exception" + this.formatPosition() + ".", e);
                    }
                }
                stack.push(this.statementObject);
                break;
            }
            case UNKNOWN: {
                throw new WarpScriptException("Unknown function " + this.statement + this.formatPosition() + ".");
            }
            case WS_EXCEPTION: {
                throw new WarpScriptException(this.statement + this.formatPosition());
            }
            case WS_EARLY_BINDING: {
                throw new WarpScriptException("WSAUDITMODE does not support early binding. (" + this.statement + ")" + this.formatPosition() + ".");
            }
            case WS_LOAD: {
                Object o = stack.load(this.statement.substring(1));
                if (null == o && !stack.getSymbolTable().containsKey(this.statement.substring(1))) {
                    throw new WarpScriptException("Unknown symbol '" + this.statement.substring(1) + "'" + this.formatPosition() + ".");
                }
                stack.push(o);
                break;
            }
            case WS_RUN: {
                try {
                    stack.run(this.statement.substring(1));
                    break;
                }
                catch (WarpScriptException e) {
                    throw new WarpScriptException("Exception" + this.formatPosition(), e);
                }
            }
        }
        return stack;
    }

    public String formatPosition() {
        return " (line " + this.lineNumber + ", position " + this.inLinePositionStart + ")";
    }

    public Map toMap() {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put(KEY_TYPE, this.type.name());
        m.put(KEY_LINE, this.lineNumber);
        m.put(KEY_POSITION, Integer.valueOf(this.inLinePositionStart).longValue());
        m.put(KEY_POSITION_END, Integer.valueOf(this.inLinePositionEnd).longValue());
        m.put(KEY_STATEMENT, this.statement);
        return m;
    }

    public String toString() {
        switch (this.type) {
            case FUNCTION_CALL: {
                return StackUtils.toString(this.statement) + " " + "FUNCREF";
            }
            case UNKNOWN: {
                return StackUtils.toString("Unknown function (" + this.statement + ")" + this.formatPosition() + ".") + " " + "MSGFAIL";
            }
            case WS_EXCEPTION: {
                return StackUtils.toString("Exception (" + this.statement + ")" + this.formatPosition() + ".") + " " + "MSGFAIL";
            }
            case WS_EARLY_BINDING: {
                return StackUtils.toString("WSAUDITMODE does not support early binding. (" + this.statement + ")" + this.formatPosition() + ".") + " " + "MSGFAIL";
            }
            case WS_LOAD: {
                return StackUtils.toString(this.statement.substring(1)) + " " + "LOAD";
            }
            case WS_RUN: {
                return StackUtils.toString(this.statement.substring(1)) + " " + "RUN";
            }
        }
        return "";
    }

    public static enum STATEMENT_TYPE {
        FUNCTION_CALL,
        WS_EXCEPTION,
        WS_EARLY_BINDING,
        WS_LOAD,
        WS_RUN,
        WS_WARNING,
        UNKNOWN;

    }
}

