/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.crypto;

import com.google.common.primitives.Longs;
import io.warp10.crypto.KeyStore;
import io.warp10.crypto.SipHashInline;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESWrapEngine;
import org.bouncycastle.crypto.generators.Argon2BytesGenerator;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.params.Argon2Parameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;

public class CryptoUtils {
    private static final String ARGON2_ITERATIONS = "argon2.iterations";
    private static final String ARGON2_ITERATIONS_DEFAULT = Integer.toString(3);
    private static final String ARGON2_MEMORY = "argon2.memory";
    private static final String ARGON2_MEMORY_DEFAULT = Integer.toString(524288);
    private static final String ARGON2_PARALLELISM = "argon2.parallelism";
    private static final String ARGON2_PARALLELISM_DEFAULT = Integer.toString(1);
    private static final long SALT_K0 = -7117808803395902232L;
    private static final long SALT_K1 = -8642716133273702435L;
    private static final long SECRET_K0 = -5957065625866540737L;
    private static final long SECRET_K1 = -4674004319992231806L;
    private static final long ADDITIONAL_K0 = 6615130406795693200L;
    private static final long ADDITIONAL_K1 = 365329543835043768L;

    public static byte[] wrap(byte[] key, byte[] data) {
        AESWrapEngine engine = new AESWrapEngine();
        KeyParameter params = new KeyParameter(key);
        engine.init(true, (CipherParameters)params);
        PKCS7Padding padding = new PKCS7Padding();
        byte[] unpadded = data;
        byte[] padded = new byte[unpadded.length + (8 - unpadded.length % 8)];
        System.arraycopy(unpadded, 0, padded, 0, unpadded.length);
        padding.addPadding(padded, unpadded.length);
        byte[] encrypted = engine.wrap(padded, 0, padded.length);
        return encrypted;
    }

    public static byte[] unwrap(byte[] key, byte[] data) {
        AESWrapEngine engine = new AESWrapEngine();
        KeyParameter params = new KeyParameter(key);
        engine.init(false, (CipherParameters)params);
        try {
            byte[] decrypted = engine.unwrap(data, 0, data.length);
            PKCS7Padding padding = new PKCS7Padding();
            int padcount = padding.padCount(decrypted);
            decrypted = Arrays.copyOfRange(decrypted, 0, decrypted.length - padcount);
            return decrypted;
        }
        catch (InvalidCipherTextException icte) {
            return null;
        }
    }

    public static byte[] addMAC(long[] key, byte[] data) {
        long hash = SipHashInline.hash24_palindromic(key[0], key[1], data);
        byte[] authenticated = Arrays.copyOf(data, data.length + 8);
        System.arraycopy(Longs.toByteArray((long)hash), 0, authenticated, data.length, 8);
        return authenticated;
    }

    public static byte[] addMAC(byte[] key, byte[] data) {
        long hash = SipHashInline.hash24_palindromic(key, data);
        byte[] authenticated = Arrays.copyOf(data, data.length + 8);
        System.arraycopy(Longs.toByteArray((long)hash), 0, authenticated, data.length, 8);
        return authenticated;
    }

    public static byte[] removeMAC(byte[] key, byte[] data) {
        long hash = SipHashInline.hash24_palindromic(key, data, 0, data.length - 8);
        long mac = Longs.fromByteArray((byte[])Arrays.copyOfRange(data, data.length - 8, data.length));
        if (mac == hash) {
            return Arrays.copyOf(data, data.length - 8);
        }
        return null;
    }

    public static byte[] removeMAC(long[] key, byte[] data) {
        long hash = SipHashInline.hash24_palindromic(key[0], key[1], data, 0, data.length - 8);
        long mac = Longs.fromByteArray((byte[])Arrays.copyOfRange(data, data.length - 8, data.length));
        if (mac == hash) {
            return Arrays.copyOf(data, data.length - 8);
        }
        return null;
    }

    public static long safeSipHash(long k0, long k1, byte[] msg) {
        byte[] a = new byte[16];
        ByteBuffer bb = ByteBuffer.wrap(a).order(ByteOrder.BIG_ENDIAN);
        bb.putLong(SipHashInline.hash24(k0, k1, msg, 0, msg.length));
        bb.putLong(SipHashInline.hash24(k0, k1, msg, 0, msg.length, true));
        return SipHashInline.hash24(k0, k1, a, 0, a.length, false);
    }

    public static byte[] invert(byte[] key) {
        byte[] inverted = Arrays.copyOf(key, key.length);
        for (int i = 0; i < inverted.length; ++i) {
            inverted[i] = (byte)(inverted[i] & 0xFF);
        }
        return inverted;
    }

    public static byte[] decodeKey(KeyStore ks, String encoded) {
        if (null == encoded) {
            return null;
        }
        if (encoded.startsWith("hex:")) {
            return Hex.decode((String)encoded.substring(4));
        }
        if (encoded.startsWith("base64:")) {
            return Base64.decode((String)encoded.substring(7));
        }
        if (encoded.startsWith("argon2id:")) {
            encoded = encoded.substring("argon2id:".length());
            String bitstr = encoded.replaceAll(":.*", "");
            int bitsize = Integer.valueOf(bitstr);
            byte[] key = CryptoUtils.decodeKey(ks, encoded.substring(bitstr.length() + 1));
            int iters = Integer.valueOf(System.getProperty(ARGON2_ITERATIONS, ARGON2_ITERATIONS_DEFAULT));
            int memory = Integer.valueOf(System.getProperty(ARGON2_MEMORY, ARGON2_MEMORY_DEFAULT));
            int parallelism = Integer.valueOf(System.getProperty(ARGON2_PARALLELISM, ARGON2_PARALLELISM_DEFAULT));
            byte[] salt = new byte[16];
            System.arraycopy(Longs.toByteArray((long)SipHashInline.hash24_palindromic(-7117808803395902232L, -8642716133273702435L, key)), 0, salt, 0, 8);
            System.arraycopy(Longs.toByteArray((long)SipHashInline.hash24_palindromic(-8642716133273702435L, -7117808803395902232L, key)), 0, salt, 8, 8);
            byte[] secret = Longs.toByteArray((long)SipHashInline.hash24_palindromic(-5957065625866540737L, -4674004319992231806L, key));
            byte[] additional = Longs.toByteArray((long)SipHashInline.hash24_palindromic(6615130406795693200L, 365329543835043768L, key));
            Argon2Parameters.Builder builder = new Argon2Parameters.Builder(2).withSalt(salt).withSecret(secret).withAdditional(additional).withVersion(19).withIterations(iters).withMemoryAsKB(memory).withParallelism(parallelism);
            Argon2BytesGenerator generator = new Argon2BytesGenerator();
            generator.init(builder.build());
            byte[] derived = new byte[bitsize >>> 3];
            generator.generateBytes(key, derived);
            return derived;
        }
        if (null != ks) {
            return ks.decodeKey(encoded);
        }
        throw new RuntimeException("Unable to decode key, KeyStore not set.");
    }

    public static byte[] decodeSimpleKey(String encoded) {
        if (null == encoded) {
            return null;
        }
        if (encoded.startsWith("hex:")) {
            return Hex.decode((String)encoded.substring(4));
        }
        if (encoded.startsWith("base64:")) {
            return Base64.decode((String)encoded.substring(7));
        }
        return null;
    }
}

