/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.continuum.store;

import io.warp10.WarpConfig;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Constants {
    private static final Logger LOG = LoggerFactory.getLogger(Constants.class);
    public static final long TIME_UNITS_PER_MS;
    public static final long TIME_UNITS_PER_S;
    public static final long NS_PER_TIME_UNIT;
    public static final String WARP10_BANNER = "  ___       __                           ____________ \n  __ |     / /_____ _______________      __<  /_  __ \\\n  __ | /| / /_  __ `/_  ___/__  __ \\     __  /_  / / /\n  __ |/ |/ / / /_/ /_  /   __  /_/ /     _  / / /_/ / \n  ____/|__/  \\__,_/ /_/    _  .___/      /_/  \\____/  \n                           /_/                        \n";
    public static final long DEFAULT_MODULUS = 1L;
    public static final long ELEVATION_UNITS_PER_M = 1000L;
    public static final String PRODUCER_LABEL = ".producer";
    public static final String OWNER_LABEL = ".owner";
    public static final String UUID_ATTRIBUTE = ".uuid";
    public static final String APPLICATION_LABEL = ".app";
    public static final String EGRESS_FETCH_ERROR_PREFIX = "# ERROR: ";
    public static final String EGRESS_FIND_ERROR_PREFIX = "# ERROR: ";
    public static final String INGRESS_DELETE_ERROR_PREFIX = "# ERROR: ";
    public static final String RUNNER_PERIODICITY = "runner.periodicity";
    public static final String RUNNER_PATH = "runner.path";
    public static final String RUNNER_SCHEDULEDAT = "runner.scheduledat";
    public static final String RUNNER_NONCE = "runner.nonce";
    public static final String RUNNER_CONTEXT_EXEC_COUNT = "runner.execution.count";
    public static final int LEVELDB_MAXPURGE_DEFAULT = 1000;
    private static final Map<String, String> HEADERS;
    public static final String HTTP_HEADER_TIMEUNIT = "X-Warp10-Timeunit";
    public static final String HTTP_HEADER_LINES = "X-Warp10-Lines";
    public static final String HTTP_HEADER_RUNNER_NONCE = "X-Warp10-Runner-Nonce";
    public static final String HTTP_HEADER_TIMEBOX = "X-Warp10-Timebox";
    public static final String HTTP_HEADER_TIMESHIFT = "X-Warp10-Timeshift";
    public static final String HTTP_HEADER_CAPABILITIES_DEFAULT = "X-Warp10-Capabilities";
    public static final String HTTP_HEADER_ELAPSED_DEFAULT = "X-Warp10-Elapsed";
    public static final String HTTP_HEADER_OPS_DEFAULT = "X-Warp10-Ops";
    public static final String HTTP_HEADER_FETCHED_DEFAULT = "X-Warp10-Fetched";
    public static final String HTTP_HEADER_ERROR_LINE_DEFAULT = "X-Warp10-Error-Line";
    public static final String HTTP_HEADER_ERROR_MESSAGE_DEFAULT = "X-Warp10-Error-Message";
    public static final String HTTP_HEADER_TOKEN_DEFAULT = "X-Warp10-Token";
    public static final String HTTP_HEADER_META_TOKEN_DEFAULT = "X-Warp10-Token";
    public static final String HTTP_HEADER_DELETE_TOKEN_DEFAULT = "X-Warp10-Token";
    public static final String HTTP_HEADER_UPDATE_TOKEN_DEFAULT = "X-Warp10-Token";
    public static final String HTTP_HEADER_FETCH_SIGNATURE_DEFAULT = "X-Warp10-Fetch-Signature";
    public static final String HTTP_HEADER_UPDATE_SIGNATURE_DEFAULT = "X-Warp10-Update-Signature";
    public static final String HTTP_HEADER_DIRECTORY_SIGNATURE_DEFAULT = "X-Warp10-Directory-Signature";
    public static final String HTTP_HEADER_EXPOSE_HEADERS_DEFAULT = "X-Warp10-ExposeHeaders";
    public static final String HTTP_HEADER_DATALOG_DEFAULT = "X-Warp10-Datalog";
    public static final String HTTP_HEADER_ATTRIBUTES_DEFAULT = "X-Warp10-Attributes";
    public static final String DATALOG_UPDATE = "UPDATE";
    public static final String DATALOG_META = "META";
    public static final String DATALOG_DELETE = "DELETE";
    public static final String API_ENDPOINT_CHECK = "/api/v0/check";
    public static final String API_ENDPOINT_SPLITS = "/api/v0/splits";
    public static final String API_ENDPOINT_EXEC = "/api/v0/exec";
    public static final String API_ENDPOINT_UPDATE = "/api/v0/update";
    public static final String API_ENDPOINT_FIND = "/api/v0/find";
    public static final String API_ENDPOINT_FETCH = "/api/v0/fetch";
    public static final String API_ENDPOINT_SFETCH = "/api/v0/sfetch";
    public static final String API_ENDPOINT_DELETE = "/api/v0/delete";
    public static final String API_ENDPOINT_PLASMA_SERVER = "/api/v0/plasma";
    public static final String API_ENDPOINT_PLASMA_UPDATE = "/api/v0/streamupdate";
    public static final String API_ENDPOINT_MOBIUS = "/api/v0/mobius";
    public static final String API_ENDPOINT_INTERACTIVE = "/api/v0/interactive";
    public static final String API_ENDPOINT_META = "/api/v0/meta";
    public static final String API_ENDPOINT_DIRECTORY_STREAMING_INTERNAL = "/directory-streaming";
    public static final String API_ENDPOINT_DIRECTORY_STATS_INTERNAL = "/directory-stats";
    public static final String OVH_CDN_GEO_HEADER = "X-CDN-Geo";
    public static final int MAX_ENCODER_SIZE;
    public static final String HTTP_PARAM_TOKEN = "token";
    public static final String HTTP_PARAM_SELECTOR = "selector";
    public static final String HTTP_PARAM_START = "start";
    public static final String HTTP_PARAM_STOP = "stop";
    public static final String HTTP_PARAM_NOW = "now";
    public static final String HTTP_PARAM_TIMESPAN = "timespan";
    public static final String HTTP_PARAM_DEDUP = "dedup";
    public static final String HTTP_PARAM_SHOW_ERRORS = "showerrors";
    public static final String HTTP_PARAM_FORMAT = "format";
    public static final String HTTP_PARAM_END = "end";
    public static final String HTTP_PARAM_DELETEALL = "deleteall";
    public static final String HTTP_PARAM_DRYRUN = "dryrun";
    public static final String HTTP_PARAM_MINAGE = "minage";
    public static final String HTTP_PARAM_SHOWUUID = "showuuid";
    public static final String HTTP_PARAM_SHOWATTR = "showattr";
    public static final String HTTP_PARAM_SORTMETA = "sortmeta";
    public static final String HTTP_PARAM_MAXSIZE = "maxsize";
    public static final String HTTP_PARAM_SUFFIX = "suffix";
    public static final String HTTP_PARAM_UNPACK = "unpack";
    public static final String HTTP_PARAM_CHUNKSIZE = "chunksize";
    public static final String HTTP_PARAM_ACTIVEAFTER = "activeafter";
    public static final String HTTP_PARAM_QUIETAFTER = "quietafter";
    public static final String HTTP_PARAM_LIMIT = "limit";
    public static final String HTTP_PARAM_GCOUNT = "gcount";
    public static final String HTTP_PARAM_GSKIP = "gskip";
    public static final String HTTP_PARAM_COUNT = "count";
    public static final String HTTP_PARAM_SKIP = "skip";
    public static final String HTTP_PARAM_STEP = "step";
    public static final String HTTP_PARAM_TIMESTEP = "timestep";
    public static final String HTTP_PARAM_SAMPLE = "sample";
    public static final String HTTP_PARAM_PREBOUNDARY = "boundary.pre";
    public static final String HTTP_PARAM_POSTBOUNDARY = "boundary.post";
    public static final String HTTP_PARAM_METAONLY = "metaonly";
    public static final String HTTP_PARAM_ATTR_PREFIX = "attr.";
    public static final String DEFAULT_PACKED_CLASS_SUFFIX = ":packed";
    public static final int DEFAULT_PACKED_MAXSIZE = 65536;
    public static final String WARP10_DOC_URL = "http://www.warp10.io/";
    public static final String WARP10_FUNCTION_DOC_URL = "http://www.warp10.io/doc/";
    public static final int WARP_PLASMA_MAXSUBS_DEFAULT = 256000;
    public static final String KEY_MODULUS = "modulus";
    public static final String KEY_ALGORITHM = "algorithm";
    public static final String KEY_EXPONENT = "exponent";
    public static final String KEY_CURVE = "curve";
    public static final String KEY_Q = "Q";
    public static final String KEY_D = "d";
    private static final int DEFAULT_MAX_ENCODER_SIZE = 100000;
    public static final String TOKEN_ATTR_END = ".end";
    public static final String TOKEN_ATTR_START = ".start";
    public static final String TOKEN_ATTR_QUIETAFTER = ".quietafter";
    public static final String TOKEN_ATTR_ACTIVEAFTER = ".activeafter";
    public static final String TOKEN_ATTR_COUNT = ".count";
    public static final String TOKEN_ATTR_BOUNDARY_PRE = ".pre";
    public static final String TOKEN_ATTR_BOUNDARY_POST = ".post";
    public static final String TOKEN_ATTR_NODELETE = ".nodelete";
    public static final String TOKEN_ATTR_NOUPDATE = ".noupdate";
    public static final String TOKEN_ATTR_NOMETA = ".nometa";
    public static final String TOKEN_ATTR_NOFIND = ".nofind";
    public static final String TOKEN_ATTR_NOFETCH = ".nofetch";
    public static final String TOKEN_ATTR_MAXSIZE = ".maxsize";
    public static final String TOKEN_ATTR_MAXFUTURE = ".maxfuture";
    public static final String TOKEN_ATTR_MAXPAST = ".maxpast";
    public static final String TOKEN_ATTR_IGNOOR = ".ignoor";
    public static final String TOKEN_ATTR_EXPOSE = ".expose";
    public static final String DEFAULT_FDB_DATA_PENDINGMUTATIONS_MAXSIZE;
    public static final String TOKEN_ATTR_FDB_TENANT_PREFIX = ".fdbtp";
    public static final String STORE_ATTR_FDB_TENANT_PREFIX = "fdb.tenant.prefix";
    public static final int MAX_HTTP_REASON_LENGTH = 1024;
    public static final int MAX_HTTP_HEADER_LENGTH = 1024;
    public static final boolean EXPOSE_OWNER_PRODUCER;
    public static final boolean ABSENT_LABEL_SUPPORT;
    public static final boolean DELETE_METAONLY_SUPPORT;
    public static final boolean DELETE_ACTIVITY_SUPPORT;
    public static final TimeUnit timeunit;
    public static final byte[] FDB_METADATA_KEY_PREFIX;
    public static final byte[] FDB_RAW_DATA_KEY_PREFIX;
    public static final String BACKEND_MEMORY = "memory";
    public static final String BACKEND_PLASMA = "plasma";
    public static final String BACKEND_NULL = "null";
    public static final String BACKEND_ARCHIVE = "archive";
    public static final String BACKEND_LEVELDB = "leveldb";
    public static final String BACKEND_FDB = "fdb";

    public static String getHeader(String name) {
        return HEADERS.get(name);
    }

    public static boolean hasReservedHeader(Map<String, String> headers) {
        HashSet<String> hdrs = new HashSet<String>();
        for (String definedHeader : headers.keySet()) {
            hdrs.add(definedHeader.toLowerCase());
        }
        for (String key : HEADERS.keySet()) {
            if (!hdrs.contains(key.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    static {
        HEADERS = new HashMap<String, String>();
        DEFAULT_FDB_DATA_PENDINGMUTATIONS_MAXSIZE = Long.toString(5000000L);
        String tu = WarpConfig.getProperty("warp.timeunits");
        if (null == tu) {
            tu = System.getProperty("warp.timeunits");
        }
        EXPOSE_OWNER_PRODUCER = "true".equals(WarpConfig.getProperty("warp10.expose.owner.producer"));
        ABSENT_LABEL_SUPPORT = "true".equals(WarpConfig.getProperty("warp10.absent.label.support"));
        DELETE_METAONLY_SUPPORT = "true".equals(WarpConfig.getProperty("ingress.delete.metaonly.support"));
        DELETE_ACTIVITY_SUPPORT = "true".equals(WarpConfig.getProperty("ingress.delete.activity.support"));
        if (null == tu) {
            throw new RuntimeException("Missing time units.");
        }
        if ("ms".equals(tu)) {
            TIME_UNITS_PER_MS = 1L;
            timeunit = TimeUnit.MILLISECONDS;
        } else if ("us".equals(tu)) {
            TIME_UNITS_PER_MS = 1000L;
            timeunit = TimeUnit.MICROSECONDS;
        } else if ("ns".equals(tu)) {
            TIME_UNITS_PER_MS = 1000000L;
            timeunit = TimeUnit.NANOSECONDS;
        } else {
            throw new RuntimeException("Invalid time unit.");
        }
        TIME_UNITS_PER_S = 1000L * TIME_UNITS_PER_MS;
        NS_PER_TIME_UNIT = 1000000L / TIME_UNITS_PER_MS;
        MAX_ENCODER_SIZE = Integer.parseInt(WarpConfig.getProperty("max.encoder.size", Integer.toString(100000)));
        if (null == System.getProperty("warp10.quiet")) {
            LOG.info("########[ Initialized with " + TIME_UNITS_PER_MS + " time units per millisecond ]########");
        }
        HEADERS.put("http.header.elapsed", WarpConfig.getProperty("http.header.elapsed", HTTP_HEADER_ELAPSED_DEFAULT));
        HEADERS.put("http.header.ops", WarpConfig.getProperty("http.header.ops", HTTP_HEADER_OPS_DEFAULT));
        HEADERS.put("http.header.fetched", WarpConfig.getProperty("http.header.fetched", HTTP_HEADER_FETCHED_DEFAULT));
        HEADERS.put("http.header.error.line", WarpConfig.getProperty("http.header.error.line", HTTP_HEADER_ERROR_LINE_DEFAULT));
        HEADERS.put("http.header.error.message", WarpConfig.getProperty("http.header.error.message", HTTP_HEADER_ERROR_MESSAGE_DEFAULT));
        HEADERS.put("http.header.token", WarpConfig.getProperty("http.header.token", "X-Warp10-Token"));
        HEADERS.put("http.header.token.META", WarpConfig.getProperty("http.header.token.META", "X-Warp10-Token"));
        HEADERS.put("http.header.token.DELETE", WarpConfig.getProperty("http.header.token.DELETE", "X-Warp10-Token"));
        HEADERS.put("http.header.token.UPDATE", WarpConfig.getProperty("http.header.token.UPDATE", "X-Warp10-Token"));
        HEADERS.put("http.header.fetch.signature", WarpConfig.getProperty("http.header.fetch.signature", HTTP_HEADER_FETCH_SIGNATURE_DEFAULT));
        HEADERS.put("http.header.update.signature", WarpConfig.getProperty("http.header.update.signature", HTTP_HEADER_UPDATE_SIGNATURE_DEFAULT));
        HEADERS.put("http.header.directory.signature", WarpConfig.getProperty("http.header.directory.signature", HTTP_HEADER_DIRECTORY_SIGNATURE_DEFAULT));
        HEADERS.put("http.header.exposeheaders", WarpConfig.getProperty("http.header.exposeheaders", HTTP_HEADER_EXPOSE_HEADERS_DEFAULT));
        HEADERS.put("http.header.attributes", WarpConfig.getProperty("http.header.attributes", HTTP_HEADER_ATTRIBUTES_DEFAULT));
        HEADERS.put("http.header.capabilities", WarpConfig.getProperty("http.header.capabilities", HTTP_HEADER_CAPABILITIES_DEFAULT));
        FDB_METADATA_KEY_PREFIX = "M".getBytes(StandardCharsets.UTF_8);
        FDB_RAW_DATA_KEY_PREFIX = "R".getBytes(StandardCharsets.UTF_8);
    }
}

