/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.continuum.gts;

public class UnsafeString {
    public static final String[] split(String s, char ch) {
        int off = 0;
        int next = 0;
        int n = 1;
        while ((next = s.indexOf(ch, off)) != -1) {
            off = next + 1;
            ++n;
        }
        next = 0;
        off = 0;
        String[] tokens = new String[n];
        int idx = 0;
        while ((next = s.indexOf(ch, off)) != -1) {
            tokens[idx++] = s.substring(off, next);
            off = next + 1;
        }
        if (off == 0) {
            return new String[]{s};
        }
        tokens[idx] = s.substring(off);
        return tokens;
    }

    public static boolean isLong(String s) {
        int i;
        for (i = 0; i < s.length() && ' ' == s.charAt(i); ++i) {
        }
        if (i == s.length()) {
            return false;
        }
        char ch = s.charAt(i);
        if ('+' != ch && '-' != ch && (ch < '0' || ch > '9')) {
            return false;
        }
        if ('-' == ch || '+' == ch) {
            ++i;
        }
        boolean hasDigits = false;
        while (i < s.length()) {
            ch = s.charAt(i);
            if (ch < '0' || ch > '9') {
                return false;
            }
            hasDigits = true;
            ++i;
        }
        return hasDigits;
    }

    public static boolean isDouble(String s) {
        int i;
        for (i = 0; i < s.length() && ' ' == s.charAt(i); ++i) {
        }
        if (i == s.length()) {
            return false;
        }
        char ch = s.charAt(i);
        if (('-' == ch || '+' == ch) && ++i >= s.length()) {
            return false;
        }
        ch = s.charAt(i);
        if (3 == s.length() - i && 'N' == ch && 'a' == s.charAt(i + 1) && 'N' == s.charAt(i + 2)) {
            return true;
        }
        if (8 == s.length() - i && 'I' == ch && 'n' == s.charAt(i + 1) && 'f' == s.charAt(i + 2) && 'i' == s.charAt(i + 3) && 'n' == s.charAt(i + 4) && 'i' == s.charAt(i + 5) && 't' == s.charAt(i + 6) && 'y' == s.charAt(i + 7)) {
            return true;
        }
        if (ch < '0' || ch > '9') {
            return false;
        }
        int ne = 0;
        int nsign = 0;
        int ndot = 0;
        while (i < s.length()) {
            ch = s.charAt(i);
            if (ch >= '0' && ch <= '9') {
                ++i;
                continue;
            }
            if ('e' == ch || 'E' == ch) {
                if (0 != nsign) {
                    return false;
                }
                ++ne;
                ++i;
                continue;
            }
            if ('-' == ch || '+' == ch) {
                if (0 == ne) {
                    return false;
                }
                ++nsign;
                ++i;
                continue;
            }
            if ('.' == ch) {
                if (0 != ne || 0 != nsign) {
                    return false;
                }
                ++ndot;
                ++i;
                continue;
            }
            return false;
        }
        if (ne > 1 || nsign > 1 || ndot > 1) {
            return false;
        }
        return false != ne || false != ndot;
    }

    public static boolean mayBeDecimalDouble(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9' || '.' == c || '+' == c || '-' == c) continue;
            return false;
        }
        return true;
    }

    public static String sanitizeStrings(String str) {
        String newstr = str;
        StringBuilder sb = null;
        boolean instring = false;
        int stringsep = 0;
        int lastidx = 0;
        for (int idx = 0; idx < str.length(); ++idx) {
            int ch = str.charAt(idx);
            if (instring && stringsep == ch) {
                if (idx == str.length() - 1 || ' ' == str.charAt(idx + 1)) {
                    instring = false;
                    stringsep = 0;
                }
            } else if (!instring) {
                if (39 == ch) {
                    instring = true;
                    stringsep = 39;
                } else if (34 == ch) {
                    instring = true;
                    stringsep = 34;
                }
            }
            if (!instring || 32 != ch) continue;
            if (null == sb) {
                sb = new StringBuilder();
            }
            for (int offset = 0; offset < idx - lastidx; ++offset) {
                sb.append(str.charAt(lastidx + offset));
            }
            sb.append("%20");
            lastidx = idx + 1;
        }
        if (null != sb) {
            if (lastidx < str.length()) {
                for (int offset = 0; offset < str.length() - lastidx; ++offset) {
                    sb.append(str.charAt(lastidx + offset));
                }
            }
            newstr = sb.toString();
        }
        return newstr;
    }
}

