/*
 * Decompiled with CFR 0.152.
 */
package io.warp10;

import com.google.common.annotations.Beta;
import io.warp10.ThrowableUtils;
import io.warp10.WarpURLDecoder;
import io.warp10.continuum.Tokens;
import io.warp10.continuum.store.Constants;
import io.warp10.script.WarpFleetMacroRepository;
import io.warp10.script.WarpScriptMacroRepository;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WarpConfig {
    private static final Logger LOG = LoggerFactory.getLogger(WarpConfig.class);
    public static final String WARP10_CONFIG = "warp10.config";
    private static final String WARP10_NOENV = "warp10.noenv";
    private static final String WARP10_NOSYS = "warp10.nosys";
    private static final String WARP10_IGNOREFAILEDEXPANDS = "warp10.ignorefailedexpands";
    public static final String WARP10_CONFIG_ENV = "WARP10_CONFIG";
    public static final String WARPSCRIPT_BOOTSTRAP = "warpscript.bootstrap";
    private static Properties properties = null;
    public static final String THREAD_PROPERTY_SESSION = ".session";
    public static final String THREAD_PROPERTY_TOKEN = ".token";
    private static String backend = null;
    private static Boolean standaloneMode = null;
    @Beta
    private static final ThreadLocal<Map<String, Object>> threadProperties = new ThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };

    @Beta
    public static Object getThreadProperty(String key) {
        return threadProperties.get().get(key);
    }

    @Beta
    public static Object setThreadProperty(String key, Object value) {
        return threadProperties.get().put(key, value);
    }

    @Beta
    public static Object removeThreadProperty(String key) {
        Map<String, Object> props = threadProperties.get();
        Object previous = props.remove(key);
        if (0 == props.size()) {
            threadProperties.remove();
        }
        return previous;
    }

    @Beta
    public static void clearThreadProperties() {
        threadProperties.remove();
    }

    public static void safeSetProperties(String ... files) throws IOException {
        WarpConfig.safeSetProperties(true, files);
    }

    public static void safeSetProperties(boolean exitOnError, String ... files) throws IOException {
        if (null != properties) {
            return;
        }
        WarpConfig.setProperties(exitOnError, files);
    }

    public static void setProperties(String ... files) throws IOException {
        WarpConfig.setProperties(true, files);
    }

    public static void setProperties(boolean exitOnError, String ... files) throws IOException {
        if (null != properties) {
            throw new RuntimeException("Properties already set.");
        }
        properties = new Properties();
        if (null != files && 0 != files.length) {
            ArrayList<String> filenames = new ArrayList<String>(Arrays.asList(files));
            ListIterator<String> iterator = filenames.listIterator();
            while (iterator.hasNext()) {
                String file = (String)iterator.next();
                if (null == file || 0 >= file.length() || '@' != file.charAt(0)) continue;
                iterator.remove();
                BufferedReader br = new BufferedReader(new FileReader(file.substring(1)));
                Throwable throwable = null;
                try {
                    String line;
                    while ((line = br.readLine()) != null) {
                        iterator.add(line);
                    }
                }
                catch (Throwable line) {
                    throwable = line;
                    throw line;
                }
                finally {
                    if (br == null) continue;
                    if (throwable != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable line) {
                            throwable.addSuppressed(line);
                        }
                        continue;
                    }
                    br.close();
                }
            }
            for (String filename : filenames) {
                if (null == filename) continue;
                File file = new File(filename);
                try {
                    FileInputStream fileInputStreamStream = new FileInputStream(file);
                    Throwable throwable = null;
                    try {
                        WarpConfig.readConfig(exitOnError, fileInputStreamStream, properties);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fileInputStreamStream == null) continue;
                        if (throwable != null) {
                            try {
                                ((InputStream)fileInputStreamStream).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((InputStream)fileInputStreamStream).close();
                    }
                }
                catch (IOException ioe) {
                    throw new IOException("Found errors while reading " + filename + ".", ioe);
                }
            }
        }
        WarpConfig.envVarsAndSysPropsOverride();
        WarpConfig.expandVars(exitOnError);
        WarpConfig.checkAndInit();
    }

    public static void safeSetProperties(Reader reader) throws IOException {
        WarpConfig.safeSetProperties(true, reader);
    }

    public static void safeSetProperties(boolean exitOnError, Reader reader) throws IOException {
        if (null != properties) {
            return;
        }
        WarpConfig.setProperties(exitOnError, reader);
    }

    public static boolean isPropertiesSet() {
        return null != properties;
    }

    public static void setProperties(Reader reader) throws IOException {
        WarpConfig.setProperties(true, reader);
    }

    public static void setProperties(boolean exitOnError, Reader reader) throws IOException {
        if (null != properties) {
            throw new RuntimeException("Properties already set.");
        }
        properties = null != reader ? WarpConfig.readConfig(exitOnError, reader, null) : WarpConfig.readConfig(exitOnError, new StringReader(""), null);
        WarpConfig.envVarsAndSysPropsOverride();
        WarpConfig.expandVars(exitOnError);
        WarpConfig.checkAndInit();
    }

    private static void checkAndInit() {
        long warpTimeunits = Constants.TIME_UNITS_PER_MS;
        if (null != properties.getProperty("warp.token.file")) {
            Tokens.init(properties.getProperty("warp.token.file"));
        }
        WarpScriptMacroRepository.init(properties);
        WarpFleetMacroRepository.init(properties);
    }

    private static Properties readConfig(boolean exitOnError, InputStream file, Properties properties) throws IOException {
        return WarpConfig.readConfig(exitOnError, new InputStreamReader(file), properties);
    }

    public static Properties readConfig(Reader reader, Properties properties) throws IOException {
        return WarpConfig.readConfig(true, reader, properties);
    }

    public static Properties readConfig(boolean exitOnError, Reader reader, Properties properties) throws IOException {
        String line;
        if (null == properties) {
            properties = new Properties();
        }
        BufferedReader br = new BufferedReader(reader);
        int lineno = 0;
        ArrayList<Integer> linesInError = new ArrayList<Integer>();
        while (null != (line = br.readLine())) {
            line = line.trim();
            ++lineno;
            if ("".equals(line) || line.startsWith("//") || line.startsWith("#") || line.startsWith("--")) continue;
            if (!line.contains("=")) {
                LOG.warn("'" + line + "' on line " + lineno + " is missing an '=' sign, skipping.");
                continue;
            }
            String[] tokens = line.split("=");
            if (tokens.length > 2) {
                linesInError.add(lineno);
                continue;
            }
            try {
                for (int i = 0; i < tokens.length; ++i) {
                    tokens[i] = tokens[i].trim();
                    tokens[i] = WarpURLDecoder.decode(tokens[i], StandardCharsets.UTF_8);
                }
            }
            catch (IllegalArgumentException iae) {
                linesInError.add(lineno);
                continue;
            }
            if (tokens.length < 2 || "".equals(tokens[1])) {
                if (properties.containsKey(tokens[0])) {
                    LOG.warn("Empty value for property '" + tokens[0] + "' on line " + lineno + ", has cleared the previous value of '" + properties.getProperty(tokens[0]) + "'");
                    properties.remove(tokens[0]);
                    continue;
                }
                LOG.warn("Empty value for property '" + tokens[0] + "' on line " + lineno + ", ignoring.");
                continue;
            }
            properties.setProperty(tokens[0], tokens[1]);
        }
        br.close();
        if (!linesInError.isEmpty()) {
            if (exitOnError) {
                LOG.error("Malformed lines " + ((Object)linesInError).toString() + " in configuration.");
                System.exit(-1);
            } else {
                throw new IOException("Malformed lines " + ((Object)linesInError).toString() + ".");
            }
        }
        return properties;
    }

    private static void envVarsAndSysPropsOverride() throws IOException {
        if (null == properties.getOrDefault((Object)WARP10_NOENV, System.getProperty(WARP10_NOENV))) {
            for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                try {
                    name = WarpURLDecoder.decode(name, StandardCharsets.UTF_8);
                    value = WarpURLDecoder.decode(value, StandardCharsets.UTF_8);
                    properties.setProperty(name, value);
                }
                catch (Exception e) {
                    LOG.warn("Failed to decode environment variable '" + entry.getKey() + "' = '" + entry.getValue() + "', using raw value.");
                    properties.setProperty(entry.getKey(), entry.getValue());
                }
            }
        }
        if (null == properties.getOrDefault((Object)WARP10_NOSYS, System.getProperty(WARP10_NOSYS))) {
            Properties sysprops = System.getProperties();
            for (Map.Entry<Object, Object> entry : sysprops.entrySet()) {
                String name = entry.getKey().toString();
                String value = entry.getValue().toString();
                try {
                    name = WarpURLDecoder.decode(name, StandardCharsets.UTF_8);
                    value = WarpURLDecoder.decode(value, StandardCharsets.UTF_8);
                    properties.setProperty(name, value);
                }
                catch (Exception e) {
                    LOG.warn("Error decoding system property '" + entry.getKey().toString() + "' = '" + entry.getValue().toString() + "', using raw values.");
                    properties.setProperty(entry.getKey().toString(), entry.getValue().toString());
                }
            }
        }
    }

    private static void expandVars(boolean exitOnError) throws IOException {
        Pattern VAR = Pattern.compile(".*\\$\\{([^}]+)\\}.*");
        HashSet<String> emptyProperties = new HashSet<String>();
        boolean ignoreFailedExpands = null != properties.getOrDefault((Object)WARP10_IGNOREFAILEDEXPANDS, System.getProperty(WARP10_IGNOREFAILEDEXPANDS));
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Matcher m;
            String name = entry.getKey().toString();
            String value = entry.getValue().toString();
            if ("''".equals(value)) {
                value = "";
            }
            int loopcount = 0;
            String origValue = value;
            while ((m = VAR.matcher(value)).matches()) {
                String var = m.group(1);
                if (properties.containsKey(var)) {
                    value = value.replace("${" + var + "}", properties.getProperty(var));
                } else {
                    LOG.warn("Property '" + var + "' referenced in property '" + name + "' is unset, unsetting '" + name + "'");
                    value = null;
                }
                if (null == value) break;
                if (++loopcount <= 100) continue;
                LOG.warn("Hmmm, that's embarrassing, but I've been dereferencing variables " + loopcount + " times trying to set a value for '" + name + "' from value '" + origValue + "'.");
                if (ignoreFailedExpands) {
                    LOG.warn("Removing property '" + name + "'.");
                    value = null;
                    break;
                }
                if (exitOnError) {
                    LOG.error("Failed to expand '" + name + "' in configuration.");
                    System.exit(-1);
                    continue;
                }
                throw new IOException("Failed to expand '" + name + "'.");
            }
            if (null == value) {
                emptyProperties.add(name);
                continue;
            }
            properties.setProperty(name, value);
        }
        for (String property : emptyProperties) {
            properties.remove(property);
        }
    }

    public static Properties getProperties() {
        if (null == properties) {
            return null;
        }
        return (Properties)properties.clone();
    }

    public static String getProperty(String key) {
        if (null == properties) {
            throw new RuntimeException("Properties not set.");
        }
        return properties.getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) {
        if (null == properties) {
            throw new RuntimeException("Properties not set.");
        }
        return properties.getProperty(key, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object setProperty(String key, String value) {
        if (null == properties) {
            return null;
        }
        Properties properties = WarpConfig.properties;
        synchronized (properties) {
            if (null == value) {
                return WarpConfig.properties.remove(key);
            }
            return WarpConfig.properties.setProperty(key, value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getOriginalFormatJavaVersion() {
        String jversion = System.getProperty("java.version");
        if (properties.containsKey("warp.java.version")) {
            return properties.getProperty("warp.java.version");
        }
        if (jversion.startsWith("1.")) {
            if (-1 != jversion.indexOf(".", 2)) return jversion;
            return jversion + ".0";
        }
        if (jversion.contains(".")) {
            if (-1 == jversion.indexOf(".", jversion.indexOf(".") + 1)) throw new RuntimeException("Unparseable Java version '" + jversion + "', please consider setting '" + "warp.java.version" + "' explicitely in your configuration file.");
            return "1." + jversion;
        }
        if (jversion.contains("+")) {
            String extra = jversion.substring(jversion.indexOf("+"));
            jversion = jversion.substring(0, jversion.indexOf("+"));
            return "1." + jversion + ".0" + extra;
        }
        if (jversion.contains("-")) {
            String extra = jversion.substring(jversion.indexOf("-"));
            jversion = jversion.substring(0, jversion.indexOf("-"));
            return "1." + jversion + ".0" + extra;
        }
        if (!"".equals(jversion.replaceAll("[0-9]+", ""))) throw new RuntimeException("Unparseable Java version '" + jversion + "', please consider setting '" + "warp.java.version" + "' explicitely in your configuration file.");
        return "1." + jversion + ".0";
    }

    public static void main(String ... args) {
        if (null != properties) {
            System.err.println("Properties already set");
            System.exit(-1);
        }
        if (StandardCharsets.UTF_8 != Charset.defaultCharset()) {
            throw new RuntimeException("Default encoding MUST be UTF-8 but it is " + Charset.defaultCharset() + ". Aborting.");
        }
        ArrayList<String> lfiles = new ArrayList<String>();
        int keycount = 0;
        for (int i = 0; i < args.length; ++i) {
            if (".".equals(args[i])) {
                keycount = args.length - i - 1;
                break;
            }
            lfiles.add(args[i]);
        }
        String[] files = lfiles.toArray(new String[lfiles.size()]);
        try {
            WarpConfig.setProperties(false, files);
            for (int i = args.length - keycount; i < args.length; ++i) {
                System.out.println("@CONF@ " + args[i] + "=" + WarpConfig.getProperty(args[i]));
            }
        }
        catch (Throwable t) {
            System.err.println(ThrowableUtils.getErrorMessage(t));
            System.exit(-1);
        }
    }

    public static synchronized void setStandaloneMode(boolean mode) {
        if (null != standaloneMode) {
            throw new RuntimeException("Mode already set.");
        }
        standaloneMode = mode;
    }

    public static boolean isStandaloneMode() {
        return null != standaloneMode && standaloneMode != false;
    }
}

