/*
 * Decompiled with CFR 0.152.
 */
package io.warp10;

import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TTransport;

public class ThriftUtils {
    public static TSerializer getTSerializer() {
        return ThriftUtils.getTSerializer(ThriftUtils.getTCompactProtocolFactory());
    }

    public static TSerializer getTSerializer(TProtocolFactory factory) {
        try {
            return new TSerializer(factory);
        }
        catch (TException te) {
            throw new RuntimeException("Error while instantiating TSerializer.", te);
        }
    }

    public static TDeserializer getTDeserializer() {
        return ThriftUtils.getTDeserializer(ThriftUtils.getTCompactProtocolFactory());
    }

    public static TDeserializer getTDeserializer(TProtocolFactory factory) {
        try {
            return new TDeserializer(factory);
        }
        catch (TException te) {
            throw new RuntimeException("Error while instantiating TDeserializer.", te);
        }
    }

    private static TProtocolFactory getTCompactProtocolFactory() {
        TCompactProtocol.Factory factory = new TCompactProtocol.Factory(){

            public TProtocol getProtocol(TTransport trans) {
                try {
                    trans.getConfiguration().setMaxMessageSize(Integer.MAX_VALUE);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                return super.getProtocol(trans);
            }
        };
        return factory;
    }
}

