/*
 * Decompiled with CFR 0.152.
 */
package io.warp10;

public class DoubleUtils {
    public static double[] muvar(double[] values, int offset, int len) {
        double sum = 0.0;
        double sumsq = 0.0;
        int n = len;
        double shift = values[offset];
        int i = 0;
        while (0.0 != shift && i < offset + len) {
            shift = values[i++];
        }
        for (i = 0; i < n; ++i) {
            double term = values[i] - shift;
            sum += term;
            sumsq += term * term;
        }
        double mean = sum / (double)n;
        double var = sumsq / (double)n - mean * mean;
        double mu = mean + shift / (double)n;
        double[] muvar = new double[]{mu, var};
        return muvar;
    }

    public static double[] muvar(double[] values) {
        return DoubleUtils.muvar(values, 0, values.length);
    }

    public static double[] musigma(double[] values, int offset, int len, boolean bessel) {
        double[] musigma = DoubleUtils.muvar(values, offset, len);
        if (bessel && len > 1) {
            musigma[1] = musigma[1] * (double)len / (double)(len - 1);
        }
        musigma[1] = Math.sqrt(musigma[1]);
        return musigma;
    }

    public static double[] musigma(double[] values, boolean bessel) {
        return DoubleUtils.musigma(values, 0, values.length, bessel);
    }
}

