//
//   Copyright 2018  SenX S.A.S.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//

package io.warp10.script.fwt.wavelets;

import io.warp10.script.fwt.Wavelet;

public class Wavelet_sym14 extends Wavelet {

  private static final int transformWavelength = 2;

  private static final double[] scalingDeComposition = new double[] { -2.5879090265397886e-05, 1.1210865808890361e-05, 0.00039843567297594335, -6.286542481477636e-05, -0.002579441725933078, 0.0003664765736601183, 0.01003769371767227, -0.002753774791224071, -0.029196217764038187, 0.004280520499019378, 0.03743308836285345, -0.057634498351326995, -0.03531811211497973, 0.39320152196208885, 0.7599762419610909, 0.4753357626342066, -0.05811182331771783, -0.15999741114652205, 0.02589858753104667, 0.06982761636180755, -0.002365048836740385, -0.019439314263626713, 0.0010131419871842082, 0.004532677471945648, -7.321421356702399e-05, -0.0006057601824664335, 1.9329016965523917e-05, 4.4618977991475265e-05,  };
  private static final double[] waveletDeComposition = new double[] { -4.4618977991475265e-05, 1.9329016965523917e-05, 0.0006057601824664335, -7.321421356702399e-05, -0.004532677471945648, 0.0010131419871842082, 0.019439314263626713, -0.002365048836740385, -0.06982761636180755, 0.02589858753104667, 0.15999741114652205, -0.05811182331771783, -0.4753357626342066, 0.7599762419610909, -0.39320152196208885, -0.03531811211497973, 0.057634498351326995, 0.03743308836285345, -0.004280520499019378, -0.029196217764038187, 0.002753774791224071, 0.01003769371767227, -0.0003664765736601183, -0.002579441725933078, 6.286542481477636e-05, 0.00039843567297594335, -1.1210865808890361e-05, -2.5879090265397886e-05,  };

  private static final double[] scalingReConstruction = new double[] { 4.4618977991475265e-05, 1.9329016965523917e-05, -0.0006057601824664335, -7.321421356702399e-05, 0.004532677471945648, 0.0010131419871842082, -0.019439314263626713, -0.002365048836740385, 0.06982761636180755, 0.02589858753104667, -0.15999741114652205, -0.05811182331771783, 0.4753357626342066, 0.7599762419610909, 0.39320152196208885, -0.03531811211497973, -0.057634498351326995, 0.03743308836285345, 0.004280520499019378, -0.029196217764038187, -0.002753774791224071, 0.01003769371767227, 0.0003664765736601183, -0.002579441725933078, -6.286542481477636e-05, 0.00039843567297594335, 1.1210865808890361e-05, -2.5879090265397886e-05,  };
  private static final double[] waveletReConstruction = new double[] { -2.5879090265397886e-05, -1.1210865808890361e-05, 0.00039843567297594335, 6.286542481477636e-05, -0.002579441725933078, -0.0003664765736601183, 0.01003769371767227, 0.002753774791224071, -0.029196217764038187, -0.004280520499019378, 0.03743308836285345, 0.057634498351326995, -0.03531811211497973, -0.39320152196208885, 0.7599762419610909, -0.4753357626342066, -0.05811182331771783, 0.15999741114652205, 0.02589858753104667, -0.06982761636180755, -0.002365048836740385, 0.019439314263626713, 0.0010131419871842082, -0.004532677471945648, -7.321421356702399e-05, 0.0006057601824664335, 1.9329016965523917e-05, -4.4618977991475265e-05,  };

  static {
    //
    // Reverse the arrays as we do convolutions
    //
    reverse(scalingDeComposition);
    reverse(waveletDeComposition);
  }

  private static final void reverse(double[] array) {
    int i = 0;
    int j = array.length - 1;
    
    while (i < j) {
      double tmp = array[i];
      array[i] = array[j];
      array[j] = tmp;
      i++;
      j--;
    }
  }

  public int getTransformWavelength() {
    return transformWavelength;
  }

  public int getMotherWavelength() {
    return waveletReConstruction.length;
  }

  public double[] getScalingDeComposition() {
    return scalingDeComposition;
  }

  public double[] getWaveletDeComposition() {
    return waveletDeComposition;
  }

  public double[] getScalingReConstruction() {
    return scalingReConstruction;
  }

  public double[] getWaveletReConstruction() {
    return waveletReConstruction;
  }
}

