//
//   Copyright 2018-2022  SenX S.A.S.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//

package io.warp10.script.functions;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.warp.sdk.Capabilities;

public class LOGMSG extends NamedWarpScriptFunction implements WarpScriptStackFunction {

  private static final Logger LOG = LoggerFactory.getLogger(LOGMSG.class);

  public LOGMSG(String name) {
    super(name);
  }

  @Override
  public Object apply(WarpScriptStack stack) throws WarpScriptException {
    Object top = stack.pop();

    if (LOG.isInfoEnabled() && (!STDOUT.useCapability || null != Capabilities.get(stack, WarpScriptStack.CAPABILITY_DEBUG))) {
      LOG.info(String.valueOf(top));
    }

    return stack;
  }
}
