//
//   Copyright 2018  SenX S.A.S.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//

package io.warp10.script.fwt.wavelets;

import io.warp10.script.fwt.Wavelet;

public class Wavelet_sym17 extends Wavelet {

  private static final int transformWavelength = 2;

  private static final double[] scalingDeComposition = new double[] { 4.297343327345983e-06, 2.7801266938414138e-06, -6.293702597554192e-05, -1.3506383399901165e-05, 0.0004759963802638669, -0.000138642302680455, -0.0027416759756816018, 0.0008567700701915741, 0.010482366933031529, -0.004819212803176148, -0.03329138349235933, 0.01790395221434112, 0.10475461484223211, 0.0172711782105185, -0.11856693261143636, 0.1423983504146782, 0.6507166292045456, 0.681488995344925, 0.18053958458111286, -0.15507600534974825, -0.08607087472073338, 0.016158808725919346, -0.007261634750928767, -0.01803889724191924, 0.009952982523509598, 0.012396988366648726, -0.001905407689852666, -0.003932325279797902, 5.8400428694052584e-05, 0.0007198270642148971, 2.520793314082878e-05, -7.607124405605129e-05, -2.4527163425833e-06, 3.7912531943321266e-06,  };
  private static final double[] waveletDeComposition = new double[] { -3.7912531943321266e-06, -2.4527163425833e-06, 7.607124405605129e-05, 2.520793314082878e-05, -0.0007198270642148971, 5.8400428694052584e-05, 0.003932325279797902, -0.001905407689852666, -0.012396988366648726, 0.009952982523509598, 0.01803889724191924, -0.007261634750928767, -0.016158808725919346, -0.08607087472073338, 0.15507600534974825, 0.18053958458111286, -0.681488995344925, 0.6507166292045456, -0.1423983504146782, -0.11856693261143636, -0.0172711782105185, 0.10475461484223211, -0.01790395221434112, -0.03329138349235933, 0.004819212803176148, 0.010482366933031529, -0.0008567700701915741, -0.0027416759756816018, 0.000138642302680455, 0.0004759963802638669, 1.3506383399901165e-05, -6.293702597554192e-05, -2.7801266938414138e-06, 4.297343327345983e-06,  };

  private static final double[] scalingReConstruction = new double[] { 3.7912531943321266e-06, -2.4527163425833e-06, -7.607124405605129e-05, 2.520793314082878e-05, 0.0007198270642148971, 5.8400428694052584e-05, -0.003932325279797902, -0.001905407689852666, 0.012396988366648726, 0.009952982523509598, -0.01803889724191924, -0.007261634750928767, 0.016158808725919346, -0.08607087472073338, -0.15507600534974825, 0.18053958458111286, 0.681488995344925, 0.6507166292045456, 0.1423983504146782, -0.11856693261143636, 0.0172711782105185, 0.10475461484223211, 0.01790395221434112, -0.03329138349235933, -0.004819212803176148, 0.010482366933031529, 0.0008567700701915741, -0.0027416759756816018, -0.000138642302680455, 0.0004759963802638669, -1.3506383399901165e-05, -6.293702597554192e-05, 2.7801266938414138e-06, 4.297343327345983e-06,  };
  private static final double[] waveletReConstruction = new double[] { 4.297343327345983e-06, -2.7801266938414138e-06, -6.293702597554192e-05, 1.3506383399901165e-05, 0.0004759963802638669, 0.000138642302680455, -0.0027416759756816018, -0.0008567700701915741, 0.010482366933031529, 0.004819212803176148, -0.03329138349235933, -0.01790395221434112, 0.10475461484223211, -0.0172711782105185, -0.11856693261143636, -0.1423983504146782, 0.6507166292045456, -0.681488995344925, 0.18053958458111286, 0.15507600534974825, -0.08607087472073338, -0.016158808725919346, -0.007261634750928767, 0.01803889724191924, 0.009952982523509598, -0.012396988366648726, -0.001905407689852666, 0.003932325279797902, 5.8400428694052584e-05, -0.0007198270642148971, 2.520793314082878e-05, 7.607124405605129e-05, -2.4527163425833e-06, -3.7912531943321266e-06,  };

  static {
    //
    // Reverse the arrays as we do convolutions
    //
    reverse(scalingDeComposition);
    reverse(waveletDeComposition);
  }

  private static final void reverse(double[] array) {
    int i = 0;
    int j = array.length - 1;
    
    while (i < j) {
      double tmp = array[i];
      array[i] = array[j];
      array[j] = tmp;
      i++;
      j--;
    }
  }

  public int getTransformWavelength() {
    return transformWavelength;
  }

  public int getMotherWavelength() {
    return waveletReConstruction.length;
  }

  public double[] getScalingDeComposition() {
    return scalingDeComposition;
  }

  public double[] getWaveletDeComposition() {
    return waveletDeComposition;
  }

  public double[] getScalingReConstruction() {
    return scalingReConstruction;
  }

  public double[] getWaveletReConstruction() {
    return waveletReConstruction;
  }
}

