/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions.shape;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.GET;
import io.warp10.script.functions.shape.CHECKSHAPE;
import io.warp10.script.functions.shape.SHAPE;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class PERMUTE
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public PERMUTE(String name) {
        super(name);
    }

    @Override
    public WarpScriptStack apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        boolean fast = false;
        if (o instanceof Boolean) {
            fast = Boolean.TRUE.equals(o);
            o = stack.pop();
        }
        if (!(o instanceof List)) {
            throw new WarpScriptException(this.getName() + " expects a LIST of LONG as second argument.");
        }
        for (Object oo : (List)o) {
            if (oo instanceof Long) continue;
            throw new WarpScriptException(this.getName() + " expects a LIST of LONG as second argument.");
        }
        List pattern = (List)o;
        o = stack.pop();
        if (!(o instanceof List)) {
            throw new WarpScriptException(this.getName() + " expects a LIST as first argument.");
        }
        List tensor = (List)o;
        if (pattern.size() > new HashSet(pattern).size()) {
            throw new WarpScriptException(this.getName() + " error: duplicate axis in permutation pattern.");
        }
        List<Long> shape = SHAPE.candidate_shape(tensor);
        if (!fast && !CHECKSHAPE.recValidateShape(tensor, shape).booleanValue()) {
            throw new WarpScriptException(this.getName() + " expects that the sizes of the nested lists are coherent together to form a tensor (or multidimensional array).");
        }
        ArrayList<Long> newShape = new ArrayList<Long>();
        for (int r = 0; r < pattern.size(); ++r) {
            newShape.add(shape.get(((Long)pattern.get(r)).intValue()));
        }
        ArrayList<Object> result = new ArrayList<Object>();
        this.recPermute(tensor, result, new ArrayList<Long>(), 0, pattern, newShape);
        stack.push(result);
        return stack;
    }

    private void recPermute(List<Object> tensor, List<Object> result, List<Long> indices, int dimension, List<Long> pattern, List<Long> newShape) throws WarpScriptException {
        int i = 0;
        while ((long)i < newShape.get(dimension)) {
            ArrayList<Long> new_indices = new ArrayList<Long>(indices);
            new_indices.add(Long.valueOf(i));
            if (newShape.size() - 1 == dimension) {
                ArrayList<Long> permutedIndices = new ArrayList<Long>();
                for (int r = 0; r < pattern.size(); ++r) {
                    permutedIndices.add((Long)new_indices.get(pattern.lastIndexOf(r)));
                }
                result.add(GET.nestedGet(tensor, permutedIndices));
            } else {
                ArrayList<Object> nested = new ArrayList<Object>();
                result.add(nested);
                this.recPermute(tensor, nested, new_indices, dimension + 1, pattern, newShape);
            }
            ++i;
        }
    }
}

