/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.GTSStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VALUESPLIT
extends GTSStackFunction {
    private static final String PARAM_LABEL = "label";

    public VALUESPLIT(String name) {
        super(name);
    }

    @Override
    protected Map<String, Object> retrieveParameters(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a label name on top of the stack.");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PARAM_LABEL, top.toString());
        return params;
    }

    @Override
    protected Object gtsOp(Map<String, Object> params, GeoTimeSerie gts) throws WarpScriptException {
        String label = params.get(PARAM_LABEL).toString();
        List<Object> series = new ArrayList();
        if (GeoTimeSerie.TYPE.BOOLEAN == gts.getType()) {
            series = GTSHelper.booleanGTSSplit(gts, true);
            ((GeoTimeSerie)series.get(0)).getMetadata().putToLabels(label, "false");
            ((GeoTimeSerie)series.get(1)).getMetadata().putToLabels(label, "true");
            if (0 == ((GeoTimeSerie)series.get(1)).size()) {
                series.remove(1);
            }
            if (0 == ((GeoTimeSerie)series.get(0)).size()) {
                series.remove(0);
            }
            return series;
        }
        GTSHelper.valueSort(gts);
        GeoTimeSerie split = null;
        Object lastvalue = null;
        for (int i = 0; i < gts.size(); ++i) {
            long tick = GTSHelper.tickAtIndex(gts, i);
            long location = GTSHelper.locationAtIndex(gts, i);
            long elevation = GTSHelper.elevationAtIndex(gts, i);
            Object value = GTSHelper.valueAtIndex(gts, i);
            if (!value.equals(lastvalue)) {
                split = gts.cloneEmpty();
                split.getMetadata().putToLabels(label, value.toString());
                series.add(split);
            }
            GTSHelper.setValue(split, tick, location, elevation, value, false);
            lastvalue = value;
        }
        return series;
    }
}

