/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.store.Constants;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.warp.sdk.Capabilities;

public class SLEEP
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public SLEEP(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        long maxSleepMs;
        if (null == Capabilities.get(stack, "sleep.maxtime")) {
            throw new WarpScriptException(this.getName() + " requires capability " + "sleep.maxtime" + ".");
        }
        try {
            maxSleepMs = Long.parseLong(Capabilities.get(stack, "sleep.maxtime"));
        }
        catch (NumberFormatException e) {
            throw new WarpScriptException(this.getName() + " cannot parse capability " + "sleep.maxtime" + ": '" + Capabilities.get(stack, "sleep.maxtime") + "' is not a valid LONG");
        }
        if (maxSleepMs <= 0L) {
            throw new WarpScriptException(this.getName() + " requires capability " + "sleep.maxtime" + " to be set to a value strictly greater than 0 ms.");
        }
        Object o = stack.pop();
        if (!(o instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a LONG period as parameter.");
        }
        long t = (Long)o;
        if ((t /= Constants.TIME_UNITS_PER_MS) > maxSleepMs) {
            throw new WarpScriptException(this.getName() + " cannot sleep during more than " + maxSleepMs + " ms, as defined in " + "sleep.maxtime" + " capability.");
        }
        try {
            Thread.sleep(t);
        }
        catch (InterruptedException e) {
            throw new WarpScriptException(this.getName() + " interrupted");
        }
        return stack;
    }
}

