/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;

public class LBOUNDS
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public LBOUNDS(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a number of intervals on top of the stack.");
        }
        int n = ((Number)top).intValue();
        if (n < 1) {
            throw new WarpScriptException(this.getName() + " cannot generate bounds for less than 1 interval.");
        }
        if (n > 65536) {
            throw new WarpScriptException(this.getName() + " cannot generate bounds for more than 65536 intervals.");
        }
        top = stack.pop();
        if (!(top instanceof Number)) {
            throw new WarpScriptException(this.getName() + " expects an upper bound below the number of intervals.");
        }
        double upper = ((Number)top).doubleValue();
        top = stack.pop();
        if (!(top instanceof Number)) {
            throw new WarpScriptException(this.getName() + " expects a lower bounds below the upper bound.");
        }
        double lower = ((Number)top).doubleValue();
        if (lower >= upper) {
            throw new WarpScriptException(this.getName() + " expects the lower bound to be strictly less than the upper bound.");
        }
        ArrayList<Double> bounds = new ArrayList<Double>(n - 1);
        double step = (upper - lower) / (double)n;
        if (0.0 == step) {
            throw new WarpScriptException(this.getName() + " cannot operate if bounds are too close.");
        }
        bounds.add(lower);
        for (int i = 1; i < n; ++i) {
            bounds.add(lower + (double)i * step);
        }
        bounds.add(upper);
        stack.push(bounds);
        return stack;
    }
}

