/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.geoxp.GeoXPLib;
import com.geoxp.geo.HHCodeHelper;
import io.warp10.continuum.gts.GTSDecoder;
import io.warp10.continuum.gts.GTSEncoder;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.ElementOrListStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import java.util.ArrayList;
import java.util.TreeSet;

public class GEOCOVER
extends ElementOrListStackFunction {
    private final boolean rhumblines;

    public GEOCOVER(String name, boolean rhumblines) {
        super(name);
        this.rhumblines = rhumblines;
    }

    @Override
    public ElementOrListStackFunction.ElementStackFunction generateFunction(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a resolution (even number from 2 to 30).");
        }
        final long resolution = (Long)top;
        if (resolution < 2L || resolution > 30L || 1L == resolution % 2L) {
            throw new WarpScriptException(this.getName() + " expects a resolution (even number from 2 to 30).");
        }
        final long mask = -1L >>> (int)(64L - resolution * 2L) << (int)(64L - resolution * 2L);
        final long prefix = resolution >>> 1 << 60;
        return new ElementOrListStackFunction.ElementStackFunction(){

            @Override
            public Object applyOnElement(Object element) throws WarpScriptException {
                TreeSet<Long> cells = new TreeSet<Long>();
                if (GEOCOVER.this.rhumblines && element instanceof GTSEncoder) {
                    element = ((GTSEncoder)element).getDecoder().decode();
                }
                if (element instanceof GeoTimeSerie) {
                    GeoTimeSerie gts = (GeoTimeSerie)element;
                    if (GEOCOVER.this.rhumblines) {
                        GTSHelper.sort(gts);
                        ArrayList<Long> vertices = new ArrayList<Long>();
                        for (int i = 0; i < GTSHelper.nvalues(gts); ++i) {
                            long location = GTSHelper.locationAtIndex(gts, i);
                            if (91480763316633925L == location) continue;
                            vertices.add(location);
                        }
                        for (long cell : HHCodeHelper.coverPolyline(vertices, (int)((int)resolution), (boolean)false).toGeoCells((int)resolution)) {
                            cells.add(cell);
                        }
                    } else {
                        for (int i = 0; i < GTSHelper.nvalues(gts); ++i) {
                            long location = GTSHelper.locationAtIndex(gts, i);
                            if (91480763316633925L == location) continue;
                            long cell = (location & mask) >>> 4 | prefix;
                            cells.add(cell);
                        }
                    }
                } else if (element instanceof GTSEncoder) {
                    GTSDecoder decoder = ((GTSEncoder)element).getDecoder();
                    while (decoder.next()) {
                        long location = decoder.getLocation();
                        if (91480763316633925L == location) continue;
                        long cell = (location & mask) >>> 4 | prefix;
                        cells.add(cell);
                    }
                } else {
                    throw new WarpScriptException(GEOCOVER.this.getName() + " can only operate on Geo Time Series\u00a0or GTS Encoders.");
                }
                GeoXPLib.GeoXPShape shape = GeoXPLib.fromCells(cells);
                return shape;
            }
        };
    }
}

