/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.lang.reflect.Constructor;
import org.bouncycastle.crypto.Digest;

public class DIGEST
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private Class digestAlgo;
    private Integer size = null;

    public DIGEST(String name, Class<? extends Digest> digestAlgo) {
        super(name);
        this.digestAlgo = digestAlgo;
    }

    public DIGEST(String name, Class<? extends Digest> digestAlgo, int size) {
        super(name);
        this.digestAlgo = digestAlgo;
        this.size = size;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        if (!(o instanceof byte[])) {
            throw new WarpScriptException(this.getName() + " operates on a byte array.");
        }
        byte[] bytes = (byte[])o;
        try {
            Digest digest;
            if (null == this.size) {
                digest = (Digest)this.digestAlgo.newInstance();
            } else {
                Constructor c = this.digestAlgo.getConstructor(Integer.TYPE);
                digest = (Digest)c.newInstance(this.size);
            }
            byte[] digestOctets = new byte[digest.getDigestSize()];
            digest.update(bytes, 0, bytes.length);
            digest.doFinal(digestOctets, 0);
            stack.push(digestOctets);
            return stack;
        }
        catch (Exception exp) {
            throw new WarpScriptException(this.getName() + " unable to instantiate message digest.", exp);
        }
    }
}

