/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.store.Constants;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptBucketizerFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.ADDDURATION;
import io.warp10.script.functions.MACROMAPPER;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

public class BUCKETIZECALENDAR
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public static final String DURATION_ATTRIBUTE_KEY = ".bucketduration";
    public static final String OFFSET_ATTRIBUTE_KEY = ".bucketoffset";
    public static final String TIMEZONE_ATTRIBUTE_KEY = ".buckettimezone";
    public static final Instant EPOCH = new Instant(0L);

    public BUCKETIZECALENDAR(String name) {
        super(name);
    }

    public BUCKETIZECALENDAR() {
        super(BUCKETIZECALENDAR.getDefaultName());
    }

    public static String getDefaultName() {
        return "BUCKETIZE.CALENDAR";
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        long N;
        long lastbucketIndex;
        ADDDURATION.ReadWritablePeriodWithSubSecondOffset bucketperiod;
        Object top = stack.pop();
        if (!(top instanceof List)) {
            throw new WarpScriptException(this.getName() + " expects a list as input.");
        }
        List params = (List)top;
        if (5 > params.size()) {
            throw new WarpScriptException(this.getName() + " needs a list of at least 5 parameters as input.");
        }
        DateTimeZone dtz = DateTimeZone.UTC;
        if (params.get(params.size() - 1) instanceof String) {
            String tz = (String)params.remove(params.size() - 1);
            dtz = DateTimeZone.forID((String)tz);
        }
        ArrayList<GeoTimeSerie> series = new ArrayList<GeoTimeSerie>();
        for (int i = 0; i < params.size() - 4; ++i) {
            if (params.get(i) instanceof GeoTimeSerie) {
                series.add((GeoTimeSerie)params.get(i));
                continue;
            }
            if (params.get(i) instanceof List) {
                for (Object o : (List)params.get(i)) {
                    if (!(o instanceof GeoTimeSerie)) {
                        throw new WarpScriptException(this.getName() + " expects a list of Geo Time Series as first parameter.");
                    }
                    series.add((GeoTimeSerie)o);
                }
                continue;
            }
            throw new WarpScriptException(this.getName() + " expects a Geo Time Series or a list of Geo Time Series as first parameter.");
        }
        if (!(params.get(params.size() - 4) instanceof WarpScriptBucketizerFunction) && !(params.get(params.size() - 4) instanceof WarpScriptStack.Macro) && null != params.get(params.size() - 4)) {
            throw new WarpScriptException(this.getName() + " expects a bucketizer function or a macro as fourth to last parameter.");
        }
        if (!(params.get(params.size() - 3) instanceof Long && params.get(params.size() - 2) instanceof String && params.get(params.size() - 1) instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects lastbucket, bucketduration, bucketcount (and optionally timezone) as last parameters.");
        }
        Object bucketizer = params.get(params.size() - 4);
        long lastbucket = (Long)params.get(params.size() - 3);
        String bucketduration = (String)params.get(params.size() - 2);
        long bucketcount = (Long)params.get(params.size() - 1);
        if (0L == lastbucket) {
            throw new WarpScriptException(this.getName() + " does not allow lastbucket to be 0. It must be specified.");
        }
        if (bucketcount < 0L) {
            throw new WarpScriptException(this.getName() + " expects a positive bucketcount.");
        }
        long maxbuckets = (Long)stack.getAttribute("stack.maxbuckets");
        if (bucketcount > maxbuckets) {
            throw new WarpScriptException(this.getName() + " error: bucket count (" + bucketcount + ") would exceed maximum value of " + maxbuckets + ". Consider raising the limit or using capabilities.");
        }
        for (GeoTimeSerie gts : series) {
            Map<String, String> attributes = gts.getMetadata().getAttributes();
            if (attributes.get(DURATION_ATTRIBUTE_KEY) == null && attributes.get(OFFSET_ATTRIBUTE_KEY) == null && attributes.get(TIMEZONE_ATTRIBUTE_KEY) == null) continue;
            throw new WarpScriptException(this.getName() + " expects GTS for which the attributes " + DURATION_ATTRIBUTE_KEY + ", " + OFFSET_ATTRIBUTE_KEY + " and " + TIMEZONE_ATTRIBUTE_KEY + " are not set. If an input GTS is supposed to be already duration-bucketized, duration-unbucketize it first before applying a new duration-bucketization.");
        }
        if (null == bucketizer) {
            throw new WarpScriptException(this.getName() + " expects a non null bucketizer.");
        }
        if ('P' != bucketduration.charAt(0)) {
            throw new WarpScriptException(this.getName() + " expects that the bucketduration is in ISO8601 duration format.");
        }
        try {
            bucketperiod = ADDDURATION.durationToPeriod(bucketduration);
        }
        catch (WarpScriptException wse) {
            throw new WarpScriptException(this.getName() + " encountered an exception.", wse);
        }
        long averageSpan = bucketperiod.getPeriod().toPeriod().toDurationFrom((ReadableInstant)EPOCH).getMillis() * Constants.TIME_UNITS_PER_MS + bucketperiod.getOffset();
        if (averageSpan < 0L) {
            throw new WarpScriptException(this.getName() + " expects the bucketduration parameter to be a positive ISO8601 duration.");
        }
        long flag = 0L;
        long bucketoffset = 0L;
        long lastbucketIndexHint = lastbucket / averageSpan;
        if (lastbucket > 0L) {
            flag = BUCKETIZECALENDAR.addNonNegativePeriod(0L, bucketperiod, DateTimeZone.UTC, lastbucketIndexHint + 1L);
            lastbucketIndex = lastbucketIndexHint;
        } else {
            flag = BUCKETIZECALENDAR.addNonNegativePeriod(0L, bucketperiod, DateTimeZone.UTC, lastbucketIndexHint);
            lastbucketIndex = lastbucketIndexHint - 1L;
        }
        while (flag > lastbucket && (N = -((flag - lastbucket) / averageSpan - 1L)) < -1L) {
            flag = BUCKETIZECALENDAR.addNonNegativePeriod(0L, bucketperiod, DateTimeZone.UTC, lastbucketIndex + N + 1L);
            lastbucketIndex += N;
        }
        while (flag <= lastbucket && (N = (lastbucket - flag) / averageSpan - 1L) > 1L) {
            flag = BUCKETIZECALENDAR.addNonNegativePeriod(0L, bucketperiod, DateTimeZone.UTC, lastbucketIndex + N + 1L);
            lastbucketIndex += N;
        }
        while (flag > lastbucket) {
            flag = BUCKETIZECALENDAR.addNonNegativePeriod(0L, bucketperiod, DateTimeZone.UTC, lastbucketIndex);
            --lastbucketIndex;
        }
        while (flag <= lastbucket) {
            flag = BUCKETIZECALENDAR.addNonNegativePeriod(0L, bucketperiod, DateTimeZone.UTC, lastbucketIndex + 2L);
            ++lastbucketIndex;
        }
        bucketoffset = flag - (lastbucket + 1L);
        ArrayList<GeoTimeSerie> bucketized = new ArrayList<GeoTimeSerie>(series.size());
        for (GeoTimeSerie gts : series) {
            GeoTimeSerie b;
            try {
                b = BUCKETIZECALENDAR.durationBucketize(gts, bucketperiod, dtz, bucketcount, lastbucket, lastbucketIndex, bucketizer, maxbuckets, bucketizer instanceof WarpScriptStack.Macro ? stack : null);
            }
            catch (WarpScriptException wse) {
                throw new WarpScriptException(this.getName() + " encountered an exception.", wse);
            }
            b.getMetadata().putToAttributes(DURATION_ATTRIBUTE_KEY, bucketduration);
            b.getMetadata().getAttributes().put(OFFSET_ATTRIBUTE_KEY, String.valueOf(bucketoffset));
            b.getMetadata().getAttributes().put(TIMEZONE_ATTRIBUTE_KEY, dtz.getID());
            bucketized.add(b);
        }
        stack.push(bucketized);
        return stack;
    }

    public static long addNonNegativePeriod(long origin, ADDDURATION.ReadWritablePeriodWithSubSecondOffset bucketperiod, DateTimeZone dtz, long N) throws WarpScriptException {
        long result = ADDDURATION.addPeriod(origin, bucketperiod, dtz, N);
        if (N == 0L) {
            return origin;
        }
        if (result > origin ^ N > 0L) {
            throw new WarpScriptException("Period is negative from timestamp " + origin + ". Can not add a negative period. Period is " + N + " times " + bucketperiod.getPeriod().toString() + " plus " + bucketperiod.getOffset() + " time unit(s).");
        }
        return result;
    }

    private static void aggregateAndSet(Object aggregator, GeoTimeSerie subgts, GeoTimeSerie bucketized, long bucketindex, WarpScriptStack stack) throws WarpScriptException {
        Object[] aggregated;
        if (null != stack) {
            stack.push(subgts);
            stack.exec((WarpScriptStack.Macro)aggregator);
            Object res = stack.peek();
            aggregated = res instanceof List ? MACROMAPPER.listToObjects((List)stack.pop()) : MACROMAPPER.stackToObjects(stack);
        } else {
            Object[] parms = new Object[8];
            parms[0] = bucketindex;
            parms[1] = new String[]{subgts.getName()};
            parms[2] = new Map[]{subgts.getLabels()};
            parms[3] = GTSHelper.getTicks(subgts);
            if (subgts.hasLocations()) {
                parms[4] = GTSHelper.getLocations(subgts);
            } else {
                parms[4] = new long[subgts.size()];
                Arrays.fill((long[])parms[4], 91480763316633925L);
            }
            if (subgts.hasElevations()) {
                parms[5] = GTSHelper.getElevations(subgts);
            } else {
                parms[5] = new long[subgts.size()];
                Arrays.fill((long[])parms[5], Long.MIN_VALUE);
            }
            parms[6] = new Object[subgts.size()];
            parms[7] = new long[]{0L, -1L, bucketindex, bucketindex};
            for (int j = 0; j < subgts.size(); ++j) {
                ((Object[])parms[6])[j] = GTSHelper.valueAtIndex(subgts, j);
            }
            aggregated = (Object[])((WarpScriptBucketizerFunction)aggregator).apply(parms);
        }
        if (null != aggregated[3]) {
            GTSHelper.setValue(bucketized, bucketindex, (Long)aggregated[1], (Long)aggregated[2], aggregated[3], false);
        }
    }

    public static GeoTimeSerie durationBucketize(GeoTimeSerie gts, ADDDURATION.ReadWritablePeriodWithSubSecondOffset bucketperiod, DateTimeZone dtz, long bucketcount, long lastbucket, long lastbucketIndex, Object aggregator, long maxbuckets, WarpScriptStack stack) throws WarpScriptException {
        long lastTick = GTSHelper.lasttick(gts);
        long firstTick = GTSHelper.firsttick(gts);
        int hint = Math.min(gts.size(), (int)(1.05 * (double)(lastTick - firstTick) / (double)BUCKETIZECALENDAR.addNonNegativePeriod(0L, bucketperiod, DateTimeZone.UTC, 1L)));
        GeoTimeSerie durationBucketized = gts.cloneEmpty(hint);
        GTSHelper.sort(gts);
        GeoTimeSerie subgts = gts.cloneEmpty();
        if (null != stack) {
            if (!(aggregator instanceof WarpScriptStack.Macro)) {
                throw new WarpScriptException("Expected a macro as bucketizer.");
            }
        } else if (!(aggregator instanceof WarpScriptBucketizerFunction)) {
            throw new WarpScriptException("Invalid bucketizer function.");
        }
        long bucketstart = BUCKETIZECALENDAR.addNonNegativePeriod(lastbucket, bucketperiod, dtz, -1L) + 1L;
        long bucketindex = lastbucketIndex;
        for (int i = gts.size() - 1; i >= 0; --i) {
            long tick = GTSHelper.tickAtIndex(gts, i);
            if (tick < bucketstart && subgts.size() > 0) {
                BUCKETIZECALENDAR.aggregateAndSet(aggregator, subgts, durationBucketized, bucketindex, stack);
                subgts = GTSHelper.shrinkTo(subgts, 0);
            }
            while (tick < bucketstart) {
                bucketstart = BUCKETIZECALENDAR.addNonNegativePeriod(lastbucket, bucketperiod, dtz, --bucketindex - lastbucketIndex - 1L) + 1L;
            }
            if (bucketcount != 0L && lastbucketIndex - bucketindex + 1L >= bucketcount) break;
            if (lastbucketIndex - bucketindex + 1L > maxbuckets) {
                throw new WarpScriptException("Bucket count (" + (lastbucketIndex - bucketindex + 1L) + ") is exceeding maximum value of " + maxbuckets + ". Consider raising the limit or using capabilities.");
            }
            if (tick > lastbucket) continue;
            GTSHelper.setValue(subgts, tick, GTSHelper.locationAtIndex(gts, i), GTSHelper.elevationAtIndex(gts, i), GTSHelper.valueAtIndex(gts, i), false);
        }
        if (subgts.size() > 0) {
            BUCKETIZECALENDAR.aggregateAndSet(aggregator, subgts, durationBucketized, bucketindex, stack);
        }
        GTSHelper.setLastBucket(durationBucketized, lastbucketIndex);
        GTSHelper.setBucketSpan(durationBucketized, 1L);
        GTSHelper.setBucketCount(durationBucketized, bucketcount == 0L ? Math.toIntExact(lastbucketIndex - bucketindex + 1L) : Math.toIntExact(bucketcount));
        GTSHelper.sort(durationBucketized);
        return durationBucketized;
    }

    public static boolean isDurationBucketized(GeoTimeSerie gts) {
        Map<String, String> attributes = gts.getMetadata().getAttributes();
        return attributes.get(DURATION_ATTRIBUTE_KEY) != null && attributes.get(OFFSET_ATTRIBUTE_KEY) != null && attributes.get(TIMEZONE_ATTRIBUTE_KEY) != null;
    }
}

