/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.store.Constants;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class ADDYEARS
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public ADDYEARS(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a number of years on top of the stack.");
        }
        int years = ((Number)top).intValue();
        top = stack.pop();
        String tz = null;
        if (top instanceof String) {
            tz = top.toString();
            top = stack.pop();
            if (!(top instanceof Long)) {
                throw new WarpScriptException(this.getName() + " operates on a tselements list, timestamp, or timestamp and timezone.");
            }
        } else if (!(top instanceof List) && !(top instanceof Long)) {
            throw new WarpScriptException(this.getName() + " operates on a tselements list, timestamp, or timestamp and timezone.");
        }
        if (top instanceof Long) {
            long instant = ((Number)top).longValue();
            if (null == tz) {
                tz = "UTC";
            }
            DateTimeZone dtz = DateTimeZone.forID((String)tz);
            DateTime dt = new DateTime(instant / Constants.TIME_UNITS_PER_MS, dtz);
            dt = dt.plusYears(years);
            long ts = dt.getMillis() * Constants.TIME_UNITS_PER_MS + instant % Constants.TIME_UNITS_PER_MS;
            stack.push(ts);
        } else {
            ArrayList<Long> elts = new ArrayList<Long>((List)top);
            int year = ((Number)elts.get(0)).intValue();
            elts.set(0, Long.valueOf(year += years));
            if (elts.size() > 2) {
                int month = ((Number)elts.get(1)).intValue();
                int day = ((Number)elts.get(2)).intValue();
                if (2 == month && day > 28 && (0 != year % 4 || 0 == year % 100)) {
                    elts.set(2, 28L);
                }
            }
            stack.push(elts);
        }
        return stack;
    }
}

