/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.ext.warprun;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;

public class FSTORE
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public FSTORE(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        boolean overwrite = false;
        if (top instanceof Boolean) {
            overwrite = Boolean.TRUE.equals(top);
            top = stack.pop();
        }
        if (!(top instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a target file path.");
        }
        Path path = new Path((String)top);
        top = stack.pop();
        byte[] data = null;
        if (top instanceof byte[]) {
            data = (byte[])top;
        } else if (top instanceof String) {
            data = ((String)top).getBytes(StandardCharsets.UTF_8);
        } else {
            throw new WarpScriptException(this.getName() + " operates on a STRING or BYTES.");
        }
        Configuration conf = new Configuration();
        conf.set("fs.hdfs.impl", DistributedFileSystem.class.getName());
        conf.set("fs.file.impl", LocalFileSystem.class.getName());
        OutputStream out = null;
        try {
            FileSystem fs = path.getFileSystem(conf);
            fs.setWriteChecksum(false);
            out = fs.create(path, overwrite);
            out.write(data);
        }
        catch (IOException ioe) {
            throw new WarpScriptException(this.getName() + " error writing '" + path + "'.", ioe);
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    throw new WarpScriptException(this.getName() + " error closing '" + path + "'.", e);
                }
            }
        }
        return stack;
    }
}

