/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.geoxp.GeoXPLib;
import io.warp10.continuum.gts.GTSDecoder;
import io.warp10.continuum.gts.GTSEncoder;
import io.warp10.continuum.store.thrift.data.Metadata;
import io.warp10.json.MetadataSerializer;
import java.io.IOException;

public class GTSEncoderSerializer
extends StdSerializer<GTSEncoder> {
    protected GTSEncoderSerializer() {
        super(GTSEncoder.class);
    }

    public void serialize(GTSEncoder encoder, JsonGenerator gen, SerializerProvider provider) throws IOException {
        Metadata metadata = encoder.getMetadata();
        gen.writeStartObject();
        MetadataSerializer.serializeMetadataFields(metadata, gen);
        gen.writeFieldName("v");
        gen.writeStartArray();
        GTSDecoder decoder = encoder.getUnsafeDecoder(false);
        while (decoder.next()) {
            long ts = decoder.getTimestamp();
            long location = decoder.getLocation();
            long elevation = decoder.getElevation();
            Object v = decoder.getValue();
            gen.writeStartArray();
            gen.writeNumber(ts);
            if (91480763316633925L != location) {
                double[] latlon = GeoXPLib.fromGeoXPPoint((long)location);
                gen.writeNumber(latlon[0]);
                gen.writeNumber(latlon[1]);
            }
            if (Long.MIN_VALUE != elevation) {
                gen.writeNumber(elevation);
            }
            if (v instanceof Boolean) {
                gen.writeBoolean(((Boolean)v).booleanValue());
            } else if (v instanceof Long) {
                gen.writeNumber(((Long)v).longValue());
            } else if (v instanceof Double) {
                gen.writeNumber(((Double)v).doubleValue());
            } else if (v instanceof String) {
                gen.writeString((String)v);
            } else {
                gen.writeObject(v);
            }
            gen.writeEndArray();
        }
        gen.writeEndArray();
        gen.writeEndObject();
    }
}

