/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.crypto;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class SipHashInline {
    public static long hash24(byte[] key, byte[] data, int offset, int len) {
        return SipHashInline.hash24(key, data, offset, len, false);
    }

    public static long hash24(byte[] key, byte[] data, int offset, int len, boolean reversed) {
        ByteBuffer bb = ByteBuffer.wrap(key);
        bb.order(ByteOrder.BIG_ENDIAN);
        long k0 = bb.getLong();
        long k1 = bb.getLong();
        return SipHashInline.hash24(k0, k1, data, offset, len, reversed);
    }

    public static long hash24(byte[] key, byte[] data) {
        return SipHashInline.hash24(key, data, 0, data.length);
    }

    public static long hash24(long k0, long k1, byte[] data, int offset, int len) {
        return SipHashInline.hash24(k0, k1, data, offset, len, false);
    }

    public static long hash24(long k0, long k1, byte[] data, int offset, int len, boolean reversed) {
        long m;
        long v0 = 0x736F6D6570736575L ^ k0;
        long v1 = 0x646F72616E646F6DL ^ k1;
        long v2 = 0x6C7967656E657261L ^ k0;
        long v3 = 0x7465646279746573L ^ k1;
        int last = len / 8 * 8;
        int i = 0;
        while (i < last) {
            if (!reversed) {
                m = SipHashInline.getLong(data, offset + i);
            } else {
                m = SipHashInline.getLong(data, offset + len - 1 - (i + 7));
                m = Long.reverseBytes(m);
            }
            i += 8;
            v0 += v1;
            v2 += (v3 ^= m);
            v1 = v1 << 13 | v1 >>> 51;
            v3 = v3 << 16 | v3 >>> 48;
            v1 ^= v0;
            v3 ^= v2;
            v0 = v0 << 32 | v0 >>> 32;
            v2 += v1;
            v0 += v3;
            v1 = v1 << 17 | v1 >>> 47;
            v3 = v3 << 21 | v3 >>> 43;
            v1 ^= v2;
            v3 ^= v0;
            v2 = v2 << 32 | v2 >>> 32;
            v0 += v1;
            v2 += v3;
            v1 = v1 << 13 | v1 >>> 51;
            v3 = v3 << 16 | v3 >>> 48;
            v1 ^= v0;
            v3 ^= v2;
            v0 = v0 << 32 | v0 >>> 32;
            v2 += v1;
            v0 += v3;
            v1 = v1 << 17 | v1 >>> 47;
            v3 = v3 << 21 | v3 >>> 43;
            v1 ^= v2;
            v3 ^= v0;
            v2 = v2 << 32 | v2 >>> 32;
            v0 ^= m;
        }
        m = 0L;
        for (i = len - 1; i >= last; --i) {
            m <<= 8;
            m |= (long)data[!reversed ? offset + i : offset + (len - 1) - i] & 0xFFL;
        }
        v0 += v1;
        v2 += (v3 ^= (m |= (long)len << 56));
        v1 = v1 << 13 | v1 >>> 51;
        v3 = v3 << 16 | v3 >>> 48;
        v1 ^= v0;
        v3 ^= v2;
        v0 = v0 << 32 | v0 >>> 32;
        v2 += v1;
        v0 += v3;
        v1 = v1 << 17 | v1 >>> 47;
        v3 = v3 << 21 | v3 >>> 43;
        v1 ^= v2;
        v3 ^= v0;
        v2 = v2 << 32 | v2 >>> 32;
        v0 += v1;
        v2 += v3;
        v1 = v1 << 13 | v1 >>> 51;
        v3 = v3 << 16 | v3 >>> 48;
        v1 ^= v0;
        v3 ^= v2;
        v0 = v0 << 32 | v0 >>> 32;
        v2 += v1;
        v0 += v3;
        v1 = v1 << 17 | v1 >>> 47;
        v3 = v3 << 21 | v3 >>> 43;
        v1 ^= v2;
        v3 ^= v0;
        v2 = v2 << 32 | v2 >>> 32;
        v0 ^= m;
        v2 ^= 0xFFL;
        v0 += v1;
        v2 += v3;
        v1 = v1 << 13 | v1 >>> 51;
        v3 = v3 << 16 | v3 >>> 48;
        v1 ^= v0;
        v3 ^= v2;
        v0 = v0 << 32 | v0 >>> 32;
        v2 += v1;
        v0 += v3;
        v1 = v1 << 17 | v1 >>> 47;
        v3 = v3 << 21 | v3 >>> 43;
        v1 ^= v2;
        v3 ^= v0;
        v2 = v2 << 32 | v2 >>> 32;
        v0 += v1;
        v2 += v3;
        v1 = v1 << 13 | v1 >>> 51;
        v3 = v3 << 16 | v3 >>> 48;
        v1 ^= v0;
        v3 ^= v2;
        v0 = v0 << 32 | v0 >>> 32;
        v2 += v1;
        v0 += v3;
        v1 = v1 << 17 | v1 >>> 47;
        v3 = v3 << 21 | v3 >>> 43;
        v1 ^= v2;
        v3 ^= v0;
        v2 = v2 << 32 | v2 >>> 32;
        v0 += v1;
        v2 += v3;
        v1 = v1 << 13 | v1 >>> 51;
        v3 = v3 << 16 | v3 >>> 48;
        v1 ^= v0;
        v3 ^= v2;
        v0 = v0 << 32 | v0 >>> 32;
        v2 += v1;
        v0 += v3;
        v1 = v1 << 17 | v1 >>> 47;
        v3 = v3 << 21 | v3 >>> 43;
        v1 ^= v2;
        v3 ^= v0;
        v2 = v2 << 32 | v2 >>> 32;
        v0 += v1;
        v2 += v3;
        v1 = v1 << 13 | v1 >>> 51;
        v3 = v3 << 16 | v3 >>> 48;
        v1 ^= v0;
        v3 ^= v2;
        v0 = v0 << 32 | v0 >>> 32;
        v2 += v1;
        v0 += v3;
        v1 = v1 << 17 | v1 >>> 47;
        v3 = v3 << 21 | v3 >>> 43;
        v1 ^= v2;
        v2 = v2 << 32 | v2 >>> 32;
        return v0 ^ v1 ^ v2 ^ (v3 ^= v0);
    }

    public static long hash24_palindromic(long k0, long k1, byte[] data, int offset, int len) {
        long m;
        long v0 = 0x736F6D6570736575L ^ k0;
        long v1 = 0x646F72616E646F6DL ^ k1;
        long v2 = 0x6C7967656E657261L ^ k0;
        long v3 = 0x7465646279746573L ^ k1;
        int last = 2 * len / 8 * 8;
        int idx = 0;
        int offset2 = offset + len + len - 1;
        int len8 = len - len % 8;
        if (last > 0) {
            while (idx < len8) {
                m = SipHashInline.getLong(data, offset + idx);
                idx += 8;
                v0 += v1;
                v2 += (v3 ^= m);
                v1 = v1 << 13 | v1 >>> 51;
                v3 = v3 << 16 | v3 >>> 48;
                v1 ^= v0;
                v3 ^= v2;
                v0 = v0 << 32 | v0 >>> 32;
                v2 += v1;
                v0 += v3;
                v1 = v1 << 17 | v1 >>> 47;
                v3 = v3 << 21 | v3 >>> 43;
                v1 ^= v2;
                v3 ^= v0;
                v2 = v2 << 32 | v2 >>> 32;
                v0 += v1;
                v2 += v3;
                v1 = v1 << 13 | v1 >>> 51;
                v3 = v3 << 16 | v3 >>> 48;
                v1 ^= v0;
                v3 ^= v2;
                v0 = v0 << 32 | v0 >>> 32;
                v2 += v1;
                v0 += v3;
                v1 = v1 << 17 | v1 >>> 47;
                v3 = v3 << 21 | v3 >>> 43;
                v1 ^= v2;
                v3 ^= v0;
                v2 = v2 << 32 | v2 >>> 32;
                v0 ^= m;
            }
            m = (long)data[offset + (idx >= len ? len - 1 - idx % len : idx)] & 0xFFL;
            m |= ((long)data[offset + (++idx >= len ? len - 1 - idx % len : idx)] & 0xFFL) << 8;
            m |= ((long)data[offset + (++idx >= len ? len - 1 - idx % len : idx)] & 0xFFL) << 16;
            m |= ((long)data[offset + (++idx >= len ? len - 1 - idx % len : idx)] & 0xFFL) << 24;
            m |= ((long)data[offset + (++idx >= len ? len - 1 - idx % len : idx)] & 0xFFL) << 32;
            m |= ((long)data[offset + (++idx >= len ? len - 1 - idx % len : idx)] & 0xFFL) << 40;
            m |= ((long)data[offset + (++idx >= len ? len - 1 - idx % len : idx)] & 0xFFL) << 48;
            int n = ++idx >= len ? len - 1 - idx % len : idx;
            ++idx;
            v0 += v1;
            v2 += (v3 ^= (m |= ((long)data[offset + n] & 0xFFL) << 56));
            v1 = v1 << 13 | v1 >>> 51;
            v3 = v3 << 16 | v3 >>> 48;
            v1 ^= v0;
            v3 ^= v2;
            v0 = v0 << 32 | v0 >>> 32;
            v2 += v1;
            v0 += v3;
            v1 = v1 << 17 | v1 >>> 47;
            v3 = v3 << 21 | v3 >>> 43;
            v1 ^= v2;
            v3 ^= v0;
            v2 = v2 << 32 | v2 >>> 32;
            v0 += v1;
            v2 += v3;
            v1 = v1 << 13 | v1 >>> 51;
            v3 = v3 << 16 | v3 >>> 48;
            v1 ^= v0;
            v3 ^= v2;
            v0 = v0 << 32 | v0 >>> 32;
            v2 += v1;
            v0 += v3;
            v1 = v1 << 17 | v1 >>> 47;
            v3 = v3 << 21 | v3 >>> 43;
            v1 ^= v2;
            v3 ^= v0;
            v2 = v2 << 32 | v2 >>> 32;
            v0 ^= m;
            while (idx < last) {
                m = Long.reverseBytes(SipHashInline.getLong(data, offset2 - (idx + 7)));
                idx += 8;
                v0 += v1;
                v2 += (v3 ^= m);
                v1 = v1 << 13 | v1 >>> 51;
                v3 = v3 << 16 | v3 >>> 48;
                v1 ^= v0;
                v3 ^= v2;
                v0 = v0 << 32 | v0 >>> 32;
                v2 += v1;
                v0 += v3;
                v1 = v1 << 17 | v1 >>> 47;
                v3 = v3 << 21 | v3 >>> 43;
                v1 ^= v2;
                v3 ^= v0;
                v2 = v2 << 32 | v2 >>> 32;
                v0 += v1;
                v2 += v3;
                v1 = v1 << 13 | v1 >>> 51;
                v3 = v3 << 16 | v3 >>> 48;
                v1 ^= v0;
                v3 ^= v2;
                v0 = v0 << 32 | v0 >>> 32;
                v2 += v1;
                v0 += v3;
                v1 = v1 << 17 | v1 >>> 47;
                v3 = v3 << 21 | v3 >>> 43;
                v1 ^= v2;
                v3 ^= v0;
                v2 = v2 << 32 | v2 >>> 32;
                v0 ^= m;
            }
        }
        m = 0L;
        if (0 != idx) {
            for (int i = 0; i < len * 2 - idx; ++i) {
                m <<= 8;
                m |= (long)data[offset + i] & 0xFFL;
            }
        } else {
            for (int i = 0; i < len * 2; ++i) {
                m <<= 8;
                m |= (long)data[offset + (i >= len ? len - 1 - i % len : i)] & 0xFFL;
            }
        }
        v0 += v1;
        v2 += (v3 ^= (m |= (long)(len * 2) << 56));
        v1 = v1 << 13 | v1 >>> 51;
        v3 = v3 << 16 | v3 >>> 48;
        v1 ^= v0;
        v3 ^= v2;
        v0 = v0 << 32 | v0 >>> 32;
        v2 += v1;
        v0 += v3;
        v1 = v1 << 17 | v1 >>> 47;
        v3 = v3 << 21 | v3 >>> 43;
        v1 ^= v2;
        v3 ^= v0;
        v2 = v2 << 32 | v2 >>> 32;
        v0 += v1;
        v2 += v3;
        v1 = v1 << 13 | v1 >>> 51;
        v3 = v3 << 16 | v3 >>> 48;
        v1 ^= v0;
        v3 ^= v2;
        v0 = v0 << 32 | v0 >>> 32;
        v2 += v1;
        v0 += v3;
        v1 = v1 << 17 | v1 >>> 47;
        v3 = v3 << 21 | v3 >>> 43;
        v1 ^= v2;
        v3 ^= v0;
        v2 = v2 << 32 | v2 >>> 32;
        v0 ^= m;
        v2 ^= 0xFFL;
        v0 += v1;
        v2 += v3;
        v1 = v1 << 13 | v1 >>> 51;
        v3 = v3 << 16 | v3 >>> 48;
        v1 ^= v0;
        v3 ^= v2;
        v0 = v0 << 32 | v0 >>> 32;
        v2 += v1;
        v0 += v3;
        v1 = v1 << 17 | v1 >>> 47;
        v3 = v3 << 21 | v3 >>> 43;
        v1 ^= v2;
        v3 ^= v0;
        v2 = v2 << 32 | v2 >>> 32;
        v0 += v1;
        v2 += v3;
        v1 = v1 << 13 | v1 >>> 51;
        v3 = v3 << 16 | v3 >>> 48;
        v1 ^= v0;
        v3 ^= v2;
        v0 = v0 << 32 | v0 >>> 32;
        v2 += v1;
        v0 += v3;
        v1 = v1 << 17 | v1 >>> 47;
        v3 = v3 << 21 | v3 >>> 43;
        v1 ^= v2;
        v3 ^= v0;
        v2 = v2 << 32 | v2 >>> 32;
        v0 += v1;
        v2 += v3;
        v1 = v1 << 13 | v1 >>> 51;
        v3 = v3 << 16 | v3 >>> 48;
        v1 ^= v0;
        v3 ^= v2;
        v0 = v0 << 32 | v0 >>> 32;
        v2 += v1;
        v0 += v3;
        v1 = v1 << 17 | v1 >>> 47;
        v3 = v3 << 21 | v3 >>> 43;
        v1 ^= v2;
        v3 ^= v0;
        v2 = v2 << 32 | v2 >>> 32;
        v0 += v1;
        v2 += v3;
        v1 = v1 << 13 | v1 >>> 51;
        v3 = v3 << 16 | v3 >>> 48;
        v1 ^= v0;
        v3 ^= v2;
        v0 = v0 << 32 | v0 >>> 32;
        v2 += v1;
        v0 += v3;
        v1 = v1 << 17 | v1 >>> 47;
        v3 = v3 << 21 | v3 >>> 43;
        v1 ^= v2;
        v2 = v2 << 32 | v2 >>> 32;
        return v0 ^ v1 ^ v2 ^ (v3 ^= v0);
    }

    public static long hash24_palindromic(byte[] key, byte[] data, int offset, int len) {
        ByteBuffer bb = ByteBuffer.wrap(key);
        bb.order(ByteOrder.BIG_ENDIAN);
        long k0 = bb.getLong();
        long k1 = bb.getLong();
        return SipHashInline.hash24_palindromic(k0, k1, data, offset, len);
    }

    public static long hash24_palindromic(long k0, long k1, byte[] data) {
        return SipHashInline.hash24_palindromic(k0, k1, data, 0, data.length);
    }

    public static long hash24_palindromic(byte[] key, byte[] data) {
        return SipHashInline.hash24_palindromic(key, data, 0, data.length);
    }

    public static long[] getKey(byte[] key) {
        if (null == key) {
            return null;
        }
        ByteBuffer bb = ByteBuffer.wrap(key);
        bb.order(ByteOrder.BIG_ENDIAN);
        long[] sipkey = new long[]{bb.getLong(), bb.getLong()};
        return sipkey;
    }

    private static long getLong(byte[] data, int offset) {
        long l = 0L;
        l = (long)data[offset + 7] & 0xFFL;
        l <<= 8;
        l |= (long)data[offset + 6] & 0xFFL;
        l <<= 8;
        l |= (long)data[offset + 5] & 0xFFL;
        l <<= 8;
        l |= (long)data[offset + 4] & 0xFFL;
        l <<= 8;
        l |= (long)data[offset + 3] & 0xFFL;
        l <<= 8;
        l |= (long)data[offset + 2] & 0xFFL;
        l <<= 8;
        l |= (long)data[offset + 1] & 0xFFL;
        l <<= 8;
        return l |= (long)data[offset] & 0xFFL;
    }
}

