/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.continuum.gts;

import com.geoxp.GeoXPLib;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.store.thrift.data.Metadata;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class GeoTimeSerie
implements Cloneable {
    TYPE type = TYPE.UNDEFINED;
    static final float ARRAY_GROWTH_FACTOR = 0.2f;
    static final int MIN_ARRAY_GROWTH = 64;
    static final int MAX_ARRAY_GROWTH = 32768;
    public static final long NO_ELEVATION = Long.MIN_VALUE;
    public static final long NO_LOCATION = 91480763316633925L;
    long bucketspan = 0L;
    int bucketcount = 0;
    long lastbucket = 0L;
    long[] ticks = null;
    long[] locations = null;
    long[] elevations = null;
    long[] longValues = null;
    double[] doubleValues = null;
    String[] stringValues = null;
    BitSet booleanValues = null;
    int values = 0;
    int sizehint = 0;
    boolean sorted = false;
    boolean reversed = false;
    private Metadata metadata;
    private boolean renamed = false;

    public GeoTimeSerie() {
    }

    public GeoTimeSerie(int sizehint) {
        this.sizehint = sizehint;
    }

    public GeoTimeSerie(long lastbucket, int bucketcount, long bucketspan, int sizehint) {
        this.lastbucket = lastbucket;
        this.bucketcount = bucketcount;
        this.bucketspan = bucketspan;
        this.sizehint = sizehint;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        GTSHelper.encodeName(sb, this.getName());
        sb.append("{");
        boolean haslabels = false;
        if (null != this.getLabels()) {
            for (Map.Entry<String, String> entry : this.getLabels().entrySet()) {
                GTSHelper.encodeName(sb, entry.getKey());
                sb.append("=");
                GTSHelper.encodeName(sb, entry.getValue());
                sb.append(",");
                haslabels = true;
            }
        }
        if (haslabels) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        sb.append("\n");
        for (int i = 0; i < this.values; ++i) {
            sb.append("=");
            sb.append(this.ticks[i]);
            sb.append("/");
            if (null != this.locations && 91480763316633925L != this.locations[i]) {
                double[] latlon = GeoXPLib.fromGeoXPPoint((long)this.locations[i]);
                sb.append(latlon[0]);
                sb.append(":");
                sb.append(latlon[1]);
            }
            sb.append("/");
            if (null != this.elevations && Long.MIN_VALUE != this.elevations[i]) {
                sb.append(this.elevations[i]);
            }
            sb.append(" ");
            if (TYPE.LONG == this.type) {
                sb.append(this.longValues[i]);
            } else if (TYPE.DOUBLE == this.type) {
                sb.append(this.doubleValues[i]);
            } else if (TYPE.STRING == this.type) {
                GTSHelper.encodeValue(sb, this.stringValues[i]);
            } else if (this.booleanValues.get(i)) {
                sb.append("T");
            } else {
                sb.append("F");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public void dump(PrintWriter pw) {
        boolean first;
        StringBuilder sb = new StringBuilder(" ");
        GTSHelper.encodeName(sb, this.getName());
        if (this.metadata.getLabelsSize() > 0) {
            sb.append("{");
            first = true;
            for (Map.Entry<String, String> entry : this.getLabels().entrySet()) {
                if (!first) {
                    sb.append(",");
                }
                GTSHelper.encodeName(sb, entry.getKey());
                sb.append("=");
                GTSHelper.encodeName(sb, entry.getValue());
                first = false;
            }
            sb.append("}");
        } else {
            sb.append("{}");
        }
        if (this.metadata.getAttributesSize() > 0) {
            sb.append("{");
            first = true;
            for (Map.Entry<String, String> entry : this.metadata.getAttributes().entrySet()) {
                if (!first) {
                    sb.append(",");
                }
                GTSHelper.encodeName(sb, entry.getKey());
                sb.append("=");
                GTSHelper.encodeName(sb, entry.getValue());
                first = false;
            }
            sb.append("}");
        } else {
            sb.append("{}");
        }
        sb.append(" ");
        String clslbs = sb.toString();
        for (int i = 0; i < this.values; ++i) {
            if (i > 0) {
                pw.print("=");
            }
            pw.print(this.ticks[i]);
            pw.print("/");
            if (null != this.locations && 91480763316633925L != this.locations[i]) {
                double[] latlon = GeoXPLib.fromGeoXPPoint((long)this.locations[i]);
                pw.print(latlon[0]);
                pw.print(":");
                pw.print(latlon[1]);
            }
            pw.print("/");
            if (null != this.elevations && Long.MIN_VALUE != this.elevations[i]) {
                pw.print(this.elevations[i]);
            }
            if (0 == i) {
                pw.print(clslbs);
            } else {
                pw.print(" ");
            }
            sb.setLength(0);
            GTSHelper.encodeValue(sb, GTSHelper.valueAtIndex(this, i));
            pw.print(sb.toString());
            pw.print("\r\n");
        }
    }

    public int size() {
        return this.values;
    }

    public GeoTimeSerie clone() {
        GeoTimeSerie serie = this.cloneEmpty();
        serie.type = this.type;
        if (null != this.ticks) {
            serie.ticks = Arrays.copyOf(this.ticks, this.values);
        }
        if (null != this.locations) {
            serie.locations = Arrays.copyOf(this.locations, this.values);
        }
        if (null != this.elevations) {
            serie.elevations = Arrays.copyOf(this.elevations, this.values);
        }
        if (TYPE.BOOLEAN == this.type && null != this.booleanValues) {
            serie.booleanValues = (BitSet)this.booleanValues.clone();
        }
        if (TYPE.DOUBLE == this.type && null != this.doubleValues) {
            serie.doubleValues = Arrays.copyOf(this.doubleValues, this.values);
        }
        if (TYPE.LONG == this.type && null != this.longValues) {
            serie.longValues = Arrays.copyOf(this.longValues, this.values);
        }
        if (TYPE.STRING == this.type && null != this.stringValues) {
            serie.stringValues = Arrays.copyOf(this.stringValues, this.values);
        }
        serie.values = this.values;
        serie.sorted = this.sorted;
        serie.reversed = this.reversed;
        return serie;
    }

    public GeoTimeSerie cloneEmpty(int sizehint) {
        GeoTimeSerie serie = new GeoTimeSerie(this.lastbucket, this.bucketcount, this.bucketspan, sizehint);
        serie.setMetadata(this.getMetadata());
        return serie;
    }

    public GeoTimeSerie cloneEmpty() {
        return this.cloneEmpty(0);
    }

    public TYPE getType() {
        return this.type;
    }

    public long getClassId() {
        return this.getMetadata().getClassId();
    }

    public void setClassId(long classId) {
        this.getMetadata().setClassId(classId);
    }

    public long getLabelsId() {
        return this.getMetadata().getLabelsId();
    }

    public void setLabelsId(long labelsId) {
        this.getMetadata().setLabelsId(labelsId);
    }

    public String getName() {
        return this.getMetadata().getName();
    }

    public void setName(String name) {
        this.getMetadata().setName(name);
    }

    public Map<String, String> getLabels() {
        return Collections.unmodifiableMap(this.getMetadata().getLabels());
    }

    public boolean hasLabel(String name) {
        return this.getMetadata().getLabels().containsKey(name);
    }

    public String getLabel(String name) {
        return this.getMetadata().getLabels().get(name);
    }

    public void setLabels(Map<String, String> labels) {
        this.getMetadata().setLabels(new HashMap<String, String>(labels));
    }

    public void setLabel(String key, String value) {
        this.getMetadata().getLabels().put(key, value);
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = new Metadata(metadata);
    }

    public void safeSetMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public Metadata getMetadata() {
        if (null == this.metadata) {
            this.metadata = new Metadata();
        }
        if (null == this.metadata.getLabels()) {
            this.metadata.setLabels(new HashMap<String, String>());
        }
        if (null == this.metadata.getAttributes()) {
            this.metadata.setAttributes(new HashMap<String, String>());
        }
        return this.metadata;
    }

    public boolean hasLocations() {
        return null != this.locations;
    }

    public boolean hasElevations() {
        return null != this.elevations;
    }

    public void setRenamed(boolean renamed) {
        this.renamed = renamed;
    }

    public boolean isRenamed() {
        return this.renamed;
    }

    public void setSizeHint(int sizehint) {
        this.sizehint = sizehint;
    }

    public void reset(long[] ticks, long[] locations, long[] elevations, double[] values, int size) throws IOException {
        int n = ticks.length;
        if (n != values.length || null != locations && n != locations.length || null != elevations && n != elevations.length) {
            throw new IOException("Incoherent array lengths");
        }
        this.ticks = ticks;
        this.locations = locations;
        this.elevations = elevations;
        this.doubleValues = values;
        this.longValues = null;
        this.booleanValues = null;
        this.stringValues = null;
        this.sorted = false;
        this.values = size;
        this.sizehint = n;
        this.type = TYPE.DOUBLE;
    }

    public void reset(long[] ticks, long[] locations, long[] elevations, long[] values, int size) throws IOException {
        int n = ticks.length;
        if (n != values.length || null != locations && n != locations.length || null != elevations && n != elevations.length) {
            throw new IOException("Incoherent array lengths");
        }
        this.ticks = ticks;
        this.locations = locations;
        this.elevations = elevations;
        this.doubleValues = null;
        this.longValues = values;
        this.booleanValues = null;
        this.stringValues = null;
        this.sorted = false;
        this.values = size;
        this.sizehint = n;
        this.type = TYPE.LONG;
    }

    public void reset(long[] ticks, long[] locations, long[] elevations, String[] values, int size) throws IOException {
        int n = ticks.length;
        if (n != values.length || null != locations && n != locations.length || null != elevations && n != elevations.length) {
            throw new IOException("Incoherent array lengths");
        }
        this.ticks = ticks;
        this.locations = locations;
        this.elevations = elevations;
        this.doubleValues = null;
        this.longValues = null;
        this.booleanValues = null;
        this.stringValues = values;
        this.sorted = false;
        this.values = size;
        this.sizehint = n;
        this.type = TYPE.STRING;
    }

    public void reset(long[] ticks, long[] locations, long[] elevations, BitSet values, int size) throws IOException {
        int n = ticks.length;
        if (n != values.size() || null != locations && n != locations.length || null != elevations && n != elevations.length) {
            throw new IOException("Incoherent array lengths");
        }
        this.ticks = ticks;
        this.locations = locations;
        this.elevations = elevations;
        this.doubleValues = null;
        this.longValues = null;
        this.booleanValues = values;
        this.stringValues = null;
        this.sorted = false;
        this.values = size;
        this.sizehint = n;
        this.type = TYPE.BOOLEAN;
    }

    public void setType(TYPE type) {
        if (!TYPE.UNDEFINED.equals((Object)this.type)) {
            return;
        }
        this.type = type;
        this.ticks = new long[0];
        switch (type) {
            case LONG: {
                this.longValues = new long[0];
                break;
            }
            case DOUBLE: {
                this.doubleValues = new double[0];
                break;
            }
            case BOOLEAN: {
                this.booleanValues = new BitSet(0);
                break;
            }
            case STRING: {
                this.stringValues = new String[0];
                break;
            }
        }
    }

    public static enum TYPE {
        UNDEFINED,
        LONG,
        DOUBLE,
        BOOLEAN,
        STRING;

    }
}

