/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.continuum.gts;

import com.geoxp.GeoXPLib;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import net.razorvine.pickle.IObjectPickler;
import net.razorvine.pickle.PickleException;
import net.razorvine.pickle.Pickler;

public class GTSPickler
implements IObjectPickler {
    private static String CLASSNAME_KEY = "classname";
    private static String LABELS_KEY = "labels";
    private static String ATTRIBUTES_KEY = "attributes";
    private static String TIMESTAMPS_KEY = "timestamps";
    private static String VALUES_KEY = "values";
    private static String LATITUDE_KEY = "latitudes";
    private static String LONGITUDE_KEY = "longitudes";
    private static String ELEVATION_KEY = "elevations";

    public void pickle(Object o, OutputStream out, Pickler currentPickler) throws PickleException, IOException {
        int i;
        if (!(o instanceof GeoTimeSerie)) {
            throw new IllegalArgumentException("Invalid type for first argument. It must be a GeoTimeSerie.");
        }
        GeoTimeSerie gts = (GeoTimeSerie)o;
        HashMap<String, Object> gtsAsMap = new HashMap<String, Object>();
        gtsAsMap.put(CLASSNAME_KEY, gts.getName());
        gtsAsMap.put(LABELS_KEY, gts.getMetadata().getLabels());
        gtsAsMap.put(ATTRIBUTES_KEY, gts.getMetadata().getAttributes());
        ArrayList<Long> ticks = new ArrayList<Long>(gts.values);
        for (int i2 = 0; i2 < gts.values; ++i2) {
            ticks.add(gts.ticks[i2]);
        }
        gtsAsMap.put(TIMESTAMPS_KEY, ticks);
        if (0 == gts.values) {
            gtsAsMap.put(VALUES_KEY, new long[0]);
        } else {
            ArrayList<Object> values = new ArrayList<Object>(gts.values);
            for (i = 0; i < gts.values; ++i) {
                values.add(GTSHelper.valueAtIndex(gts, i));
            }
            gtsAsMap.put(VALUES_KEY, values);
        }
        if (gts.hasLocations()) {
            long[] locations = gts.locations;
            ArrayList<Float> lats = new ArrayList<Float>();
            ArrayList<Float> lons = new ArrayList<Float>();
            for (int i3 = 0; i3 < gts.values; ++i3) {
                if (91480763316633925L == locations[i3]) {
                    lats.add(Float.valueOf(Float.NaN));
                    lons.add(Float.valueOf(Float.NaN));
                    continue;
                }
                double[] latlon = GeoXPLib.fromGeoXPPoint((long)locations[i3]);
                lats.add(Float.valueOf((float)latlon[0]));
                lons.add(Float.valueOf((float)latlon[1]));
            }
            gtsAsMap.put(LATITUDE_KEY, lats);
            gtsAsMap.put(LONGITUDE_KEY, lons);
        }
        if (gts.hasElevations()) {
            ArrayList<Long> elevs = new ArrayList<Long>(gts.values);
            for (i = 0; i < gts.values; ++i) {
                elevs.add(gts.elevations[i]);
            }
            gtsAsMap.put(ELEVATION_KEY, elevs);
        }
        currentPickler.save(gtsAsMap);
    }
}

