/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.StackUtils;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;

public class RANDPDF
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final SecureRandom sr = new SecureRandom();
    private final Object[] values;
    private final double[] cumulativeProbability;
    private Map<Object, Double> probabilities;
    private final boolean seeded;

    public RANDPDF(String name, Map<Object, Double> probabilities, boolean seeded) {
        super(name);
        this.probabilities = probabilities;
        this.values = new Object[probabilities.size()];
        this.cumulativeProbability = new double[probabilities.size()];
        this.seeded = seeded;
        double cumulative = 0.0;
        int idx = 0;
        for (Map.Entry<Object, Double> entry : probabilities.entrySet()) {
            this.values[idx] = entry.getKey();
            this.cumulativeProbability[idx++] = cumulative += entry.getValue().doubleValue();
        }
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        double rand;
        if (this.seeded) {
            Random prng = (Random)stack.getAttribute("seeded.prng");
            if (null == prng) {
                throw new WarpScriptException(this.getName() + " seeded PRNG was not initialized.");
            }
            rand = prng.nextDouble();
        } else {
            rand = sr.nextDouble();
        }
        int pos = Arrays.binarySearch(this.cumulativeProbability, rand);
        if (pos >= 0) {
            stack.push(this.values[pos]);
        } else if (this.cumulativeProbability.length == (pos = -pos - 1)) {
            stack.push(this.values[this.values.length - 1]);
        } else {
            stack.push(this.values[pos]);
        }
        return stack;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append(" ");
        for (Map.Entry<Object, Double> entry : this.probabilities.entrySet()) {
            sb.append(StackUtils.toString(entry.getKey()));
            sb.append(" ");
            sb.append(StackUtils.toString(entry.getValue()));
            sb.append(" ");
        }
        sb.append(" ");
        sb.append("}");
        sb.append(" ");
        sb.append(this.getName());
        return sb.toString();
    }

    public static class Builder
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        private final boolean seeded;

        public Builder(String name, boolean seeded) {
            super(name);
            this.seeded = seeded;
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            Object histogram = stack.pop();
            if (!(histogram instanceof Map)) {
                throw new WarpScriptException(this.getName() + " expects a value histogram on top of the stack.");
            }
            TreeMap<Object, Double> probabilities = new TreeMap<Object, Double>();
            double total = 0.0;
            for (Number number : ((Map)histogram).values()) {
                total += number.doubleValue();
            }
            for (Map.Entry entry : ((Map)histogram).entrySet()) {
                probabilities.put(entry.getKey(), ((Number)entry.getValue()).doubleValue() / total);
            }
            stack.push(new RANDPDF(this.getName(), probabilities, this.seeded));
            return stack;
        }
    }
}

