/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.GTSStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import java.util.HashMap;
import java.util.Map;

public class MONOTONIC
extends GTSStackFunction {
    private static final String PARAM_ORDER = "order";

    public MONOTONIC(String name) {
        super(name);
    }

    @Override
    protected Map<String, Object> retrieveParameters(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        if (!(o instanceof Boolean)) {
            throw new WarpScriptException(this.getName() + " expects a boolean on top of the stack.");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PARAM_ORDER, Boolean.TRUE.equals(o));
        return params;
    }

    @Override
    protected Object gtsOp(Map<String, Object> params, GeoTimeSerie gts) throws WarpScriptException {
        boolean bvalue;
        String svalue;
        double dvalue;
        long lvalue;
        boolean decreasing = Boolean.TRUE.equals(params.get(PARAM_ORDER));
        GTSHelper.sort(gts, false);
        GeoTimeSerie monotonic = gts.cloneEmpty();
        int n = GTSHelper.nvalues(gts);
        GeoTimeSerie.TYPE type = gts.getType();
        if (decreasing) {
            lvalue = Long.MAX_VALUE;
            dvalue = Double.POSITIVE_INFINITY;
            svalue = null;
            bvalue = true;
        } else {
            lvalue = Long.MIN_VALUE;
            dvalue = Double.NEGATIVE_INFINITY;
            svalue = "";
            bvalue = false;
        }
        for (int i = 0; i < n; ++i) {
            long tick = GTSHelper.tickAtIndex(gts, i);
            long location = GTSHelper.locationAtIndex(gts, i);
            long elevation = GTSHelper.elevationAtIndex(gts, i);
            Object value = GTSHelper.valueAtIndex(gts, i);
            switch (type) {
                case LONG: {
                    long lv = ((Number)value).longValue();
                    if (decreasing) {
                        if (lv < lvalue) {
                            lvalue = lv;
                        }
                    } else if (lv > lvalue) {
                        lvalue = lv;
                    }
                    value = lvalue;
                    break;
                }
                case DOUBLE: {
                    double dv = ((Number)value).doubleValue();
                    if (decreasing) {
                        if (dv < dvalue) {
                            dvalue = dv;
                        }
                    } else if (dv > dvalue) {
                        dvalue = dv;
                    }
                    value = dvalue;
                    break;
                }
                case STRING: {
                    String sv = value.toString();
                    if (decreasing) {
                        if (null == svalue || sv.compareTo(svalue) < 0) {
                            svalue = sv;
                        }
                    } else if (sv.compareTo(svalue) > 0) {
                        svalue = sv;
                    }
                    value = svalue;
                    break;
                }
                case BOOLEAN: {
                    boolean bv = Boolean.TRUE.equals(value);
                    if (decreasing) {
                        if (Boolean.FALSE.equals(bv)) {
                            bvalue = bv;
                        }
                    } else if (Boolean.TRUE.equals(bv)) {
                        bvalue = bv;
                    }
                    value = bvalue;
                    break;
                }
            }
            GTSHelper.setValue(monotonic, tick, location, elevation, value, false);
        }
        return monotonic;
    }
}

