/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.json.JsonUtils;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JSONTO
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public JSONTO(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        if (!(o instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a string on top of the stack.");
        }
        try {
            Object json = JsonUtils.jsonToObject(o.toString());
            stack.push(JSONTO.transform(json));
        }
        catch (IOException ioe) {
            throw new WarpScriptException(this.getName() + " failed to parse JSON", ioe);
        }
        return stack;
    }

    private static final Object transform(Object json) {
        if (json instanceof List) {
            List l = (List)json;
            ArrayList<Object> target = new ArrayList<Object>();
            for (int i = 0; i < l.size(); ++i) {
                target.add(JSONTO.transform(l.get(i)));
            }
            return target;
        }
        if (json instanceof Map) {
            Map map = (Map)json;
            HashMap<Object, Object> target = new HashMap<Object, Object>();
            for (Map.Entry entry : map.entrySet()) {
                target.put(JSONTO.transform(entry.getKey()), JSONTO.transform(entry.getValue()));
            }
            return target;
        }
        if (json instanceof Integer) {
            return ((Integer)json).longValue();
        }
        return json;
    }
}

